/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.utils;

import cn.lili.cache.Cache;
import cn.lili.common.utils.SnowFlake;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SnowflakeInitiator {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeInitiator.class);
    private static final String KEY = "{Snowflake}";
    @Autowired
    private Cache cache;

    public static void main(String[] args) {
        SnowFlake.initialize(0L, 8L);
        System.out.println(SnowFlake.getId());
    }

    @PostConstruct
    public void init() {
        Long num = this.cache.incr(KEY);
        long dataCenter = num / 32L;
        long workedId = num % 32L;
        if (dataCenter >= 32L) {
            this.cache.remove(KEY);
            num = this.cache.incr(KEY);
            dataCenter = num / 32L;
            workedId = num % 32L;
        }
        SnowFlake.initialize(workedId, dataCenter);
    }
}

