/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.utils;

import cn.lili.common.utils.MainApplicationContextHolder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class SpringEnvironmentUtils {
    private static final String DEV = "dev";
    private static final String TEST = "test";
    private static final String RELEASE = "release";

    private SpringEnvironmentUtils() {
    }

    public static LinkedHashMap<String, Object> getFlatEnvironments(Environment environment) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (PropertySource propertySource : ((AbstractEnvironment)environment).getPropertySources()) {
            SpringEnvironmentUtils.handlePropertySource(propertySource, properties);
        }
        return properties;
    }

    private static void handlePropertySource(PropertySource propertySource, LinkedHashMap<String, Object> properties) {
        if (propertySource instanceof EnumerablePropertySource) {
            for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                properties.putIfAbsent(key, propertySource.getProperty(key));
            }
        }
        if (propertySource instanceof PropertiesPropertySource) {
            for (Map.Entry entry : ((Map)((MapPropertySource)propertySource).getSource()).entrySet()) {
                properties.putIfAbsent((String)entry.getKey(), entry.getValue());
            }
        }
        if (propertySource instanceof CompositePropertySource) {
            for (Map.Entry entry : SpringEnvironmentUtils.getPropertiesInCompositePropertySource((CompositePropertySource)propertySource).entrySet()) {
                properties.putIfAbsent((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private static LinkedHashMap<String, Object> getPropertiesInCompositePropertySource(CompositePropertySource compositePropertySource) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        compositePropertySource.getPropertySources().forEach(propertySource -> {
            if (propertySource instanceof EnumerablePropertySource) {
                for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                    properties.putIfAbsent(key, propertySource.getProperty(key));
                }
            }
            if (propertySource instanceof MapPropertySource) {
                for (Map.Entry entry : ((Map)((MapPropertySource)propertySource).getSource()).entrySet()) {
                    properties.putIfAbsent((String)entry.getKey(), entry.getValue());
                }
            }
            if (propertySource instanceof CompositePropertySource) {
                for (Map.Entry entry : SpringEnvironmentUtils.getPropertiesInCompositePropertySource((CompositePropertySource)propertySource).entrySet()) {
                    properties.putIfAbsent((String)entry.getKey(), entry.getValue());
                }
            }
        });
        return properties;
    }

    private static String[] getActiveProfiles() {
        if (MainApplicationContextHolder.getApplicationContext() == null) {
            throw new IllegalStateException("\u5e94\u7528\u8fd8\u6ca1\u6709\u542f\u52a8\uff0c\u4f60\u8fc7\u65e9\u5730\u8c03\u7528\u4e86\u5224\u65ad\u73af\u5883\u7684\u65b9\u6cd5");
        }
        return MainApplicationContextHolder.getApplicationContext().getEnvironment().getActiveProfiles();
    }

    public static boolean isDevEnv() {
        for (String p : SpringEnvironmentUtils.getActiveProfiles()) {
            if (!DEV.equals(p)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestEnv() {
        for (String p : SpringEnvironmentUtils.getActiveProfiles()) {
            if (!TEST.equals(p)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReleaseEnv() {
        String[] activeProfiles;
        for (String p : activeProfiles = SpringEnvironmentUtils.getActiveProfiles()) {
            if (p == null || !p.startsWith(RELEASE)) continue;
            return true;
        }
        return false;
    }

    public static String getCurrentEnv() {
        if (SpringEnvironmentUtils.isDevEnv()) {
            return DEV;
        }
        if (SpringEnvironmentUtils.isTestEnv()) {
            return TEST;
        }
        if (SpringEnvironmentUtils.isReleaseEnv()) {
            return RELEASE;
        }
        throw new IllegalStateException("\u6ca1\u6709\u83b7\u53d6\u7cfb\u7edf\u73af\u5883");
    }
}

