/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.elasticsearch;

import cn.hutool.core.bean.BeanUtil;
import cn.lili.elasticsearch.config.ElasticsearchProperties;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseElasticsearchService {
    private static final Logger log = LoggerFactory.getLogger(BaseElasticsearchService.class);
    protected static final RequestOptions COMMON_OPTIONS;
    @Autowired
    @Qualifier(value="elasticsearchClient")
    protected RestHighLevelClient client;
    @Autowired
    private ElasticsearchProperties elasticsearchProperties;

    private static DeleteIndexRequest buildDeleteIndexRequest(String index) {
        return new DeleteIndexRequest(index);
    }

    protected static IndexRequest buildIndexRequest(String index, String id, Object object) {
        return new IndexRequest(index).id(id).source(BeanUtil.beanToMap((Object)object, (String[])new String[0]), XContentType.JSON);
    }

    protected void createIndexRequest(String index) {
        try {
            CreateIndexRequest request = new CreateIndexRequest(index);
            request.settings(Settings.builder().put("index.number_of_shards", this.elasticsearchProperties.getIndex().getNumberOfShards().intValue()).put("index.number_of_replicas", this.elasticsearchProperties.getIndex().getNumberOfReplicas().intValue()).put("index.mapping.total_fields.limit", 2000));
            CreateIndexResponse createIndexResponse = this.client.indices().create(request, COMMON_OPTIONS);
            this.createMapping(index);
            log.info(" whether all of the nodes have acknowledged the request : {}", (Object)createIndexResponse.isAcknowledged());
            log.info(" Indicates whether the requisite number of shard copies were started for each shard in the index before timing out :{}", (Object)createIndexResponse.isShardsAcknowledged());
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7d22\u5f15\u9519\u8bef", (Throwable)e);
            throw new ElasticsearchException("\u521b\u5efa\u7d22\u5f15 {" + index + "} \u5931\u8d25\uff1a" + e.getMessage(), new Object[0]);
        }
    }

    public void createMapping(String index) throws Exception {
        String source = " {\n    \"properties\": {\n      \"_class\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"attrList\": {\n        \"type\": \"nested\",\n        \"properties\": {\n          \"name\": {\n            \"type\": \"keyword\"\n          },\n          \"type\": {\n            \"type\": \"integer\"\n          },\n          \"value\": {\n            \"type\": \"keyword\"\n          }\n        }\n      },\n      \"brandId\": {\n        \"type\": \"text\",\n        \"fielddata\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"brandName\": {\n        \"type\": \"text\",\n        \"fielddata\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"brandUrl\": {\n        \"type\": \"text\",\n        \"fielddata\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"buyCount\": {\n        \"type\": \"long\"\n      },\n      \"releaseTime\": {\n        \"type\": \"date\",\n        \"format\": \"yyyy-MM-dd HH:mm:ss||yyyy-MM-dd||epoch_millis\"\n      },\n      \"categoryPath\": {\n        \"type\": \"text\",\n        \"fielddata\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"categoryNamePath\": {\n        \"type\": \"text\",\n        \"fielddata\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"commentNum\": {\n        \"type\": \"long\"\n      },\n      \"skuSource\": {\n        \"type\": \"long\"\n      },\n      \"goodsId\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"goodsName\": {\n        \"type\": \"text\",\n        \"fielddata\": true, \n        \"analyzer\": \"ik_max_word\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"grade\": {\n        \"type\": \"float\"\n      },\n      \"highPraiseNum\": {\n        \"type\": \"long\"\n      },\n      \"id\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"intro\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"authFlag\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"marketEnable\": {\n        \"type\": \"text\",\n        \"fielddata\": true, \n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"mobileIntro\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"point\": {\n        \"type\": \"long\"\n      },\n      \"price\": {\n        \"type\": \"float\"\n      },\n      \"salesModel\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"recommend\": {\n        \"type\": \"boolean\"\n      },\n      \"selfOperated\": {\n        \"type\": \"boolean\"\n      },\n      \"sellerId\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"sellerName\": {\n        \"type\": \"text\",\n        \"fielddata\": true, \n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"shopCategoryPath\": {\n        \"type\": \"text\",\n        \"fielddata\": true, \n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"sn\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      },\n      \"promotionMapJson\": {\n        \"type\": \"keyword\"\n      },\n      \"thumbnail\": {\n        \"type\": \"text\",\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"keyword\",\n            \"ignore_above\": 256\n          }\n        }\n      }\n    }\n  }\n";
        PutMappingRequest request = new PutMappingRequest(new String[]{index}).source(source, XContentType.JSON);
        final CountDownLatch latch = new CountDownLatch(1);
        this.client.indices().putMappingAsync(request, RequestOptions.DEFAULT, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse r) {
                latch.countDown();
                log.info("\u521b\u5efa\u7d22\u5f15mapping\u6210\u529f\uff1a{}", (Object)r);
            }

            public void onFailure(Exception e) {
                latch.countDown();
                log.error("\u521b\u5efa\u7d22\u5f15mapping\u5931\u8d25", (Throwable)e);
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
    }

    public boolean indexExist(String index) {
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{index});
            request.local(false);
            request.humanReadable(true);
            request.includeDefaults(false);
            return this.client.indices().exists(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new ElasticsearchException("\u83b7\u53d6\u7d22\u5f15 {" + index + "} \u662f\u5426\u5b58\u5728\u5931\u8d25\uff1a" + e.getMessage(), new Object[0]);
        }
    }

    protected void deleteIndexRequest(String index) {
        DeleteIndexRequest deleteIndexRequest = BaseElasticsearchService.buildDeleteIndexRequest(index);
        try {
            this.client.indices().delete(deleteIndexRequest, COMMON_OPTIONS);
        }
        catch (IOException e) {
            throw new ElasticsearchException("\u5220\u9664\u7d22\u5f15 {" + index + "} \u5931\u8d25\uff1a" + e.getMessage(), new Object[0]);
        }
    }

    protected void updateRequest(String index, String id, Object object) {
        try {
            UpdateRequest updateRequest = new UpdateRequest(index, id).doc(BeanUtil.beanToMap((Object)object, (String[])new String[0]), XContentType.JSON);
            this.client.update(updateRequest, COMMON_OPTIONS);
        }
        catch (IOException e) {
            throw new ElasticsearchException("\u66f4\u65b0\u7d22\u5f15 {" + index + "} \u6570\u636e {" + object + "} \u5931\u8d25: " + e.getMessage(), new Object[0]);
        }
    }

    protected void deleteRequest(String index, String id) {
        try {
            DeleteRequest deleteRequest = new DeleteRequest(index, id);
            this.client.delete(deleteRequest, COMMON_OPTIONS);
        }
        catch (IOException e) {
            throw new ElasticsearchException("\u5220\u9664\u7d22\u5f15 {" + index + "} \u6570\u636eid {" + id + "} \u5931\u8d25: " + e.getMessage(), new Object[0]);
        }
    }

    protected SearchResponse search(String index) {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.client.search(searchRequest, COMMON_OPTIONS);
        }
        catch (IOException e) {
            log.error("es \u641c\u7d22\u9519\u8bef", (Throwable)e);
        }
        return searchResponse;
    }

    protected SearchResponse search(String index, SearchSourceBuilder builder) {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        searchRequest.source(builder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.client.search(searchRequest, COMMON_OPTIONS);
        }
        catch (IOException e) {
            log.error("es \u641c\u7d22\u9519\u8bef", (Throwable)e);
        }
        return searchResponse;
    }

    static {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        builder.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(0x1E00000));
        COMMON_OPTIONS = builder.build();
    }
}

