/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.elasticsearch.config;

import cn.hutool.core.convert.Convert;
import cn.lili.elasticsearch.config.ElasticsearchProperties;
import java.io.IOException;
import java.util.List;
import javax.annotation.PreDestroy;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.config.AbstractElasticsearchConfiguration;

@Configuration
public class ElasticsearchConfig
extends AbstractElasticsearchConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchConfig.class);
    @Autowired
    private ElasticsearchProperties elasticsearchProperties;
    private RestHighLevelClient client;

    @Bean
    public RestHighLevelClient elasticsearchClient() {
        RestClientBuilder restBuilder = RestClient.builder((HttpHost[])this.getHttpHosts());
        restBuilder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setKeepAliveStrategy(this.getConnectionKeepAliveStrategy()).setMaxConnPerRoute(10).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build()));
        String username = this.elasticsearchProperties.getAccount().getUsername();
        String password = this.elasticsearchProperties.getAccount().getPassword();
        if (username != null && password != null) {
            BasicCredentialsProvider credential = new BasicCredentialsProvider();
            credential.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            restBuilder.setHttpClientConfigCallback(arg_0 -> this.lambda$elasticsearchClient$1((CredentialsProvider)credential, arg_0));
        }
        restBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(1000).setSocketTimeout(12000).setConnectionRequestTimeout(-1));
        this.client = new RestHighLevelClient(restBuilder);
        return this.client;
    }

    private HttpHost[] getHttpHosts() {
        List<String> clusterNodes = this.elasticsearchProperties.getClusterNodes();
        HttpHost[] httpHosts = new HttpHost[clusterNodes.size()];
        for (int i = 0; i < clusterNodes.size(); ++i) {
            String[] node = clusterNodes.get(i).split(":");
            httpHosts[i] = new HttpHost(node[0], Convert.toInt((Object)node[1]).intValue(), this.elasticsearchProperties.getSchema());
        }
        return httpHosts;
    }

    private ConnectionKeepAliveStrategy getConnectionKeepAliveStrategy() {
        return (response, context) -> 120000L;
    }

    @PreDestroy
    public void clientClose() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            log.error("es clientClose\u9519\u8bef", (Throwable)e);
        }
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$elasticsearchClient$1(CredentialsProvider credential, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credential).setKeepAliveStrategy(this.getConnectionKeepAliveStrategy()).setMaxConnPerRoute(10).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).build());
    }
}

