/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.elasticsearch.config;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="lili.data.elasticsearch")
public class ElasticsearchProperties {
    private String schema = "https";
    private String clusterName = "cn/lili/elasticsearch";
    @NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    private @NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a") List<String> clusterNodes = new ArrayList<String>();
    private String indexPrefix;
    private Integer connectTimeout = 1000;
    private Integer socketTimeout = 30000;
    private Integer connectionRequestTimeout = 500;
    private Integer maxConnectPerRoute = 10;
    private Integer maxConnectTotal = 30;
    private Index index = new Index();
    private Account account = new Account();

    public static ElasticsearchPropertiesBuilder builder() {
        return new ElasticsearchPropertiesBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    @NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a")
    public @NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a") List<String> getClusterNodes() {
        return this.clusterNodes;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public Integer getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public Integer getMaxConnectPerRoute() {
        return this.maxConnectPerRoute;
    }

    public Integer getMaxConnectTotal() {
        return this.maxConnectTotal;
    }

    public Index getIndex() {
        return this.index;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setClusterNodes(@NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a") List<String> clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectionRequestTimeout(Integer connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setMaxConnectPerRoute(Integer maxConnectPerRoute) {
        this.maxConnectPerRoute = maxConnectPerRoute;
    }

    public void setMaxConnectTotal(Integer maxConnectTotal) {
        this.maxConnectTotal = maxConnectTotal;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchProperties)) {
            return false;
        }
        ElasticsearchProperties other = (ElasticsearchProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$connectTimeout = this.getConnectTimeout();
        Integer other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Integer this$socketTimeout = this.getSocketTimeout();
        Integer other$socketTimeout = other.getSocketTimeout();
        if (this$socketTimeout == null ? other$socketTimeout != null : !((Object)this$socketTimeout).equals(other$socketTimeout)) {
            return false;
        }
        Integer this$connectionRequestTimeout = this.getConnectionRequestTimeout();
        Integer other$connectionRequestTimeout = other.getConnectionRequestTimeout();
        if (this$connectionRequestTimeout == null ? other$connectionRequestTimeout != null : !((Object)this$connectionRequestTimeout).equals(other$connectionRequestTimeout)) {
            return false;
        }
        Integer this$maxConnectPerRoute = this.getMaxConnectPerRoute();
        Integer other$maxConnectPerRoute = other.getMaxConnectPerRoute();
        if (this$maxConnectPerRoute == null ? other$maxConnectPerRoute != null : !((Object)this$maxConnectPerRoute).equals(other$maxConnectPerRoute)) {
            return false;
        }
        Integer this$maxConnectTotal = this.getMaxConnectTotal();
        Integer other$maxConnectTotal = other.getMaxConnectTotal();
        if (this$maxConnectTotal == null ? other$maxConnectTotal != null : !((Object)this$maxConnectTotal).equals(other$maxConnectTotal)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        List<String> this$clusterNodes = this.getClusterNodes();
        List<String> other$clusterNodes = other.getClusterNodes();
        if (this$clusterNodes == null ? other$clusterNodes != null : !((Object)this$clusterNodes).equals(other$clusterNodes)) {
            return false;
        }
        String this$indexPrefix = this.getIndexPrefix();
        String other$indexPrefix = other.getIndexPrefix();
        if (this$indexPrefix == null ? other$indexPrefix != null : !this$indexPrefix.equals(other$indexPrefix)) {
            return false;
        }
        Index this$index = this.getIndex();
        Index other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Account this$account = this.getAccount();
        Account other$account = other.getAccount();
        return !(this$account == null ? other$account != null : !((Object)this$account).equals(other$account));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Integer $socketTimeout = this.getSocketTimeout();
        result = result * 59 + ($socketTimeout == null ? 43 : ((Object)$socketTimeout).hashCode());
        Integer $connectionRequestTimeout = this.getConnectionRequestTimeout();
        result = result * 59 + ($connectionRequestTimeout == null ? 43 : ((Object)$connectionRequestTimeout).hashCode());
        Integer $maxConnectPerRoute = this.getMaxConnectPerRoute();
        result = result * 59 + ($maxConnectPerRoute == null ? 43 : ((Object)$maxConnectPerRoute).hashCode());
        Integer $maxConnectTotal = this.getMaxConnectTotal();
        result = result * 59 + ($maxConnectTotal == null ? 43 : ((Object)$maxConnectTotal).hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        List<String> $clusterNodes = this.getClusterNodes();
        result = result * 59 + ($clusterNodes == null ? 43 : ((Object)$clusterNodes).hashCode());
        String $indexPrefix = this.getIndexPrefix();
        result = result * 59 + ($indexPrefix == null ? 43 : $indexPrefix.hashCode());
        Index $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Account $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        return result;
    }

    public String toString() {
        return "ElasticsearchProperties(schema=" + this.getSchema() + ", clusterName=" + this.getClusterName() + ", clusterNodes=" + this.getClusterNodes() + ", indexPrefix=" + this.getIndexPrefix() + ", connectTimeout=" + this.getConnectTimeout() + ", socketTimeout=" + this.getSocketTimeout() + ", connectionRequestTimeout=" + this.getConnectionRequestTimeout() + ", maxConnectPerRoute=" + this.getMaxConnectPerRoute() + ", maxConnectTotal=" + this.getMaxConnectTotal() + ", index=" + this.getIndex() + ", account=" + this.getAccount() + ")";
    }

    public ElasticsearchProperties() {
    }

    public ElasticsearchProperties(String schema, String clusterName, @NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a") List<String> clusterNodes, String indexPrefix, Integer connectTimeout, Integer socketTimeout, Integer connectionRequestTimeout, Integer maxConnectPerRoute, Integer maxConnectTotal, Index index, Account account) {
        this.schema = schema;
        this.clusterName = clusterName;
        this.clusterNodes = clusterNodes;
        this.indexPrefix = indexPrefix;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.maxConnectPerRoute = maxConnectPerRoute;
        this.maxConnectTotal = maxConnectTotal;
        this.index = index;
        this.account = account;
    }

    public static class ElasticsearchPropertiesBuilder {
        private String schema;
        private String clusterName;
        private List<String> clusterNodes;
        private String indexPrefix;
        private Integer connectTimeout;
        private Integer socketTimeout;
        private Integer connectionRequestTimeout;
        private Integer maxConnectPerRoute;
        private Integer maxConnectTotal;
        private Index index;
        private Account account;

        ElasticsearchPropertiesBuilder() {
        }

        public ElasticsearchPropertiesBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ElasticsearchPropertiesBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public ElasticsearchPropertiesBuilder clusterNodes(@NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="\u96c6\u7fa4\u8282\u70b9\u4e0d\u5141\u8bb8\u4e3a\u7a7a") List<String> clusterNodes) {
            this.clusterNodes = clusterNodes;
            return this;
        }

        public ElasticsearchPropertiesBuilder indexPrefix(String indexPrefix) {
            this.indexPrefix = indexPrefix;
            return this;
        }

        public ElasticsearchPropertiesBuilder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ElasticsearchPropertiesBuilder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ElasticsearchPropertiesBuilder connectionRequestTimeout(Integer connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public ElasticsearchPropertiesBuilder maxConnectPerRoute(Integer maxConnectPerRoute) {
            this.maxConnectPerRoute = maxConnectPerRoute;
            return this;
        }

        public ElasticsearchPropertiesBuilder maxConnectTotal(Integer maxConnectTotal) {
            this.maxConnectTotal = maxConnectTotal;
            return this;
        }

        public ElasticsearchPropertiesBuilder index(Index index) {
            this.index = index;
            return this;
        }

        public ElasticsearchPropertiesBuilder account(Account account) {
            this.account = account;
            return this;
        }

        public ElasticsearchProperties build() {
            return new ElasticsearchProperties(this.schema, this.clusterName, this.clusterNodes, this.indexPrefix, this.connectTimeout, this.socketTimeout, this.connectionRequestTimeout, this.maxConnectPerRoute, this.maxConnectTotal, this.index, this.account);
        }

        public String toString() {
            return "ElasticsearchProperties.ElasticsearchPropertiesBuilder(schema=" + this.schema + ", clusterName=" + this.clusterName + ", clusterNodes=" + this.clusterNodes + ", indexPrefix=" + this.indexPrefix + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", connectionRequestTimeout=" + this.connectionRequestTimeout + ", maxConnectPerRoute=" + this.maxConnectPerRoute + ", maxConnectTotal=" + this.maxConnectTotal + ", index=" + this.index + ", account=" + this.account + ")";
        }
    }

    public static class Account {
        private String username;
        private String password;

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Account)) {
                return false;
            }
            Account other = (Account)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Account;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "ElasticsearchProperties.Account(username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }

    public static class Index {
        private Integer numberOfShards = 3;
        private Integer numberOfReplicas = 2;

        public Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public Integer getNumberOfReplicas() {
            return this.numberOfReplicas;
        }

        public void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        public void setNumberOfReplicas(Integer numberOfReplicas) {
            this.numberOfReplicas = numberOfReplicas;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Index)) {
                return false;
            }
            Index other = (Index)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$numberOfShards = this.getNumberOfShards();
            Integer other$numberOfShards = other.getNumberOfShards();
            if (this$numberOfShards == null ? other$numberOfShards != null : !((Object)this$numberOfShards).equals(other$numberOfShards)) {
                return false;
            }
            Integer this$numberOfReplicas = this.getNumberOfReplicas();
            Integer other$numberOfReplicas = other.getNumberOfReplicas();
            return !(this$numberOfReplicas == null ? other$numberOfReplicas != null : !((Object)this$numberOfReplicas).equals(other$numberOfReplicas));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Index;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $numberOfShards = this.getNumberOfShards();
            result = result * 59 + ($numberOfShards == null ? 43 : ((Object)$numberOfShards).hashCode());
            Integer $numberOfReplicas = this.getNumberOfReplicas();
            result = result * 59 + ($numberOfReplicas == null ? 43 : ((Object)$numberOfReplicas).hashCode());
            return result;
        }

        public String toString() {
            return "ElasticsearchProperties.Index(numberOfShards=" + this.getNumberOfShards() + ", numberOfReplicas=" + this.getNumberOfReplicas() + ")";
        }
    }
}

