/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.connect.request;

import cn.lili.cache.Cache;
import cn.lili.common.utils.HttpUtils;
import cn.lili.common.utils.StringUtils;
import cn.lili.common.utils.UrlBuilder;
import cn.lili.common.utils.UuidUtils;
import cn.lili.modules.connect.config.AuthConfig;
import cn.lili.modules.connect.config.ConnectAuth;
import cn.lili.modules.connect.entity.dto.AuthCallback;
import cn.lili.modules.connect.entity.dto.AuthResponse;
import cn.lili.modules.connect.entity.dto.AuthToken;
import cn.lili.modules.connect.entity.dto.ConnectAuthUser;
import cn.lili.modules.connect.entity.enums.AuthResponseStatus;
import cn.lili.modules.connect.exception.AuthException;
import cn.lili.modules.connect.request.AuthRequest;
import cn.lili.modules.connect.util.AuthChecker;
import com.xkcoding.http.util.UrlUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuthRequest
implements AuthRequest {
    private static final Logger log = LoggerFactory.getLogger(BaseAuthRequest.class);
    protected AuthConfig config;
    protected ConnectAuth source;
    protected Cache cache;

    public BaseAuthRequest(AuthConfig config, ConnectAuth connectAuth, Cache cache) {
        this.config = config;
        this.source = connectAuth;
        this.cache = cache;
        if (!AuthChecker.isSupportedAuth(config, this.source)) {
            throw new AuthException(AuthResponseStatus.PARAMETER_INCOMPLETE, this.source);
        }
        AuthChecker.checkConfig(config, this.source);
    }

    protected abstract AuthToken getAccessToken(AuthCallback var1);

    protected abstract ConnectAuthUser getUserInfo(AuthToken var1);

    @Override
    public AuthResponse login(AuthCallback authCallback) {
        try {
            AuthChecker.checkCode(this.source, authCallback);
            AuthToken authToken = this.getAccessToken(authCallback);
            ConnectAuthUser user = this.getUserInfo(authToken);
            return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(user).build();
        }
        catch (Exception e) {
            log.error("Failed to login with oauth authorization.", (Throwable)e);
            return this.responseError(e);
        }
    }

    private AuthResponse responseError(Exception e) {
        int errorCode = AuthResponseStatus.FAILURE.getCode();
        String errorMsg = e.getMessage();
        if (e instanceof AuthException) {
            AuthException authException = (AuthException)e;
            errorCode = authException.getErrorCode();
            if (StringUtils.isNotEmpty((CharSequence)authException.getErrorMsg())) {
                errorMsg = authException.getErrorMsg();
            }
        }
        return AuthResponse.builder().code(errorCode).msg(errorMsg).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl((String)this.source.authorize()).queryParam("response_type", (Object)"code").queryParam("client_id", (Object)this.config.getClientId()).queryParam("redirect_uri", (Object)this.config.getRedirectUri()).queryParam("state", (Object)this.getRealState(state)).build();
    }

    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl((String)this.source.accessToken()).queryParam("code", (Object)code).queryParam("client_id", (Object)this.config.getClientId()).queryParam("client_secret", (Object)this.config.getClientSecret()).queryParam("grant_type", (Object)"authorization_code").queryParam("redirect_uri", (Object)this.config.getRedirectUri()).build();
    }

    protected String refreshTokenUrl(String refreshToken) {
        return UrlBuilder.fromBaseUrl((String)this.source.refresh()).queryParam("client_id", (Object)this.config.getClientId()).queryParam("client_secret", (Object)this.config.getClientSecret()).queryParam("refresh_token", (Object)refreshToken).queryParam("grant_type", (Object)"refresh_token").queryParam("redirect_uri", (Object)this.config.getRedirectUri()).build();
    }

    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl((String)this.source.userInfo()).queryParam("access_token", (Object)authToken.getAccessToken()).build();
    }

    protected String revokeUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl((String)this.source.revoke()).queryParam("access_token", (Object)authToken.getAccessToken()).build();
    }

    protected String getRealState(String state) {
        if (StringUtils.isEmpty((CharSequence)state)) {
            state = UuidUtils.getUUID();
        }
        this.cache.put((Object)state, (Object)state, Long.valueOf(600L));
        return state;
    }

    protected String doPostAuthorizationCode(String code) {
        return new HttpUtils(this.config.getHttpConfig()).post(this.accessTokenUrl(code));
    }

    protected String doGetAuthorizationCode(String code) {
        return new HttpUtils(this.config.getHttpConfig()).get(this.accessTokenUrl(code));
    }

    @Deprecated
    protected String doPostUserInfo(AuthToken authToken) {
        return new HttpUtils(this.config.getHttpConfig()).post(this.userInfoUrl(authToken));
    }

    protected String doGetUserInfo(AuthToken authToken) {
        return new HttpUtils(this.config.getHttpConfig()).get(this.userInfoUrl(authToken));
    }

    @Deprecated
    protected String doPostRevoke(AuthToken authToken) {
        return new HttpUtils(this.config.getHttpConfig()).post(this.revokeUrl(authToken));
    }

    protected String doGetRevoke(AuthToken authToken) {
        return new HttpUtils(this.config.getHttpConfig()).get(this.revokeUrl(authToken));
    }

    protected String getScopes(String separator, boolean encode, List<String> defaultScopes) {
        List<String> scopes = this.config.getScopes();
        if (null == scopes || scopes.isEmpty()) {
            if (null == defaultScopes || defaultScopes.isEmpty()) {
                return "";
            }
            scopes = defaultScopes;
        }
        if (null == separator) {
            separator = " ";
        }
        String scopeStr = String.join((CharSequence)separator, scopes);
        return encode ? UrlUtil.urlEncode((String)scopeStr) : scopeStr;
    }
}

