/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.file.plugin.impl;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.file.entity.enums.OssEnum;
import cn.lili.modules.file.plugin.FilePlugin;
import cn.lili.modules.system.entity.dto.OssSetting;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.PutObjectRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiFilePlugin
implements FilePlugin {
    private static final Logger log = LoggerFactory.getLogger(HuaweiFilePlugin.class);
    private OssSetting ossSetting;

    public HuaweiFilePlugin(OssSetting ossSetting) {
        this.ossSetting = ossSetting;
    }

    @Override
    public OssEnum pluginName() {
        return OssEnum.HUAWEI_OBS;
    }

    private ObsClient getObsClient() {
        return new ObsClient(this.ossSetting.getHuaweicloudOBSAccessKey(), this.ossSetting.getHuaweicloudOBSSecretKey(), this.ossSetting.getAliyunOSSEndPoint());
    }

    @Override
    public String pathUpload(String filePath, String key) {
        ObsClient obsClient = this.getObsClient();
        try {
            obsClient.putObject(this.ossSetting.getHuaweicloudOBSBucketName(), key, new File(filePath));
        }
        catch (ObsException ce) {
            log.error("Error Message: " + ce.getMessage());
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        finally {
            try {
                obsClient.close();
            }
            catch (IOException e) {
                log.error("OBS\u5173\u95ed\u8fde\u63a5\u62a5\u9519\uff01" + e.getMessage());
                throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
            }
        }
        return this.getUrlPrefix() + key;
    }

    @Override
    public String uploadAndGetDownloadUrl(InputStream inputStream, String fileName) {
        return null;
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String key) {
        ObsClient obsClient = this.getObsClient();
        try {
            obsClient.putObject(new PutObjectRequest(this.ossSetting.getHuaweicloudOBSBucketName(), key, inputStream));
        }
        catch (ObsException obsException) {
            throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
        }
        finally {
            try {
                obsClient.close();
            }
            catch (IOException e) {
                log.error("OBS\u5173\u95ed\u8fde\u63a5\u62a5\u9519\uff01" + e.getMessage());
                throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
            }
        }
        return this.getUrlPrefix() + key;
    }

    @Override
    public void deleteFile(List<String> keys) {
        ObsClient obsClient = this.getObsClient();
        try {
            DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.ossSetting.getHuaweicloudOBSBucketName());
            for (String key : keys) {
                deleteRequest.addKeyAndVersion(key);
            }
            DeleteObjectsResult deleteResult = obsClient.deleteObjects(deleteRequest);
            log.info("\u5220\u9664\u6210\u529f\uff1a" + deleteResult.getDeletedObjectResults());
            log.info("\u5220\u9664\u5931\u8d25\uff1a" + deleteResult.getErrorResults());
        }
        catch (ObsException obsException) {
            throw new ServiceException(ResultCode.OSS_DELETE_ERROR);
        }
        finally {
            try {
                obsClient.close();
            }
            catch (IOException e) {
                log.error("OBS\u5173\u95ed\u8fde\u63a5\u62a5\u9519\uff01" + e.getMessage());
                throw new ServiceException(ResultCode.OSS_EXCEPTION_ERROR);
            }
        }
    }

    private String getUrlPrefix() {
        return "https://" + this.ossSetting.getHuaweicloudOBSBucketName() + "." + this.ossSetting.getHuaweicloudOBSEndPoint() + "/";
    }
}

