/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.file.plugin.impl;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.file.entity.enums.OssEnum;
import cn.lili.modules.file.plugin.FilePlugin;
import cn.lili.modules.system.entity.dto.OssSetting;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.messages.DeleteObject;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioFilePlugin
implements FilePlugin {
    private static final Logger log = LoggerFactory.getLogger(MinioFilePlugin.class);
    private OssSetting ossSetting;
    private static final String BUCKET_PARAM = "${bucket}";
    private static final String READ_ONLY = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:GetBucketLocation\",\"s3:ListBucket\"],\"Resource\":[\"arn:aws:s3:::${bucket}\"]},{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:GetObject\"],\"Resource\":[\"arn:aws:s3:::${bucket}/*\"]}]}";
    private static final String WRITE_ONLY = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:GetBucketLocation\",\"s3:ListBucketMultipartUploads\"],\"Resource\":[\"arn:aws:s3:::${bucket}\"]},{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:AbortMultipartUpload\",\"s3:DeleteObject\",\"s3:ListMultipartUploadParts\",\"s3:PutObject\"],\"Resource\":[\"arn:aws:s3:::${bucket}/*\"]}]}";
    private static final String READ_WRITE = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:GetBucketLocation\",\"s3:ListBucket\",\"s3:ListBucketMultipartUploads\"],\"Resource\":[\"arn:aws:s3:::${bucket}\"]},{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:DeleteObject\",\"s3:GetObject\",\"s3:ListMultipartUploadParts\",\"s3:PutObject\",\"s3:AbortMultipartUpload\"],\"Resource\":[\"arn:aws:s3:::${bucket}/*\"]}]}";
    private MinioClient minioClient;

    public MinioFilePlugin(OssSetting ossSetting) {
        this.ossSetting = ossSetting;
    }

    @Override
    public OssEnum pluginName() {
        return OssEnum.MINIO;
    }

    @Override
    public String pathUpload(String filePath, String key) {
        try {
            return this.inputStreamUpload(new FileInputStream(filePath), key);
        }
        catch (Exception e) {
            throw new ServiceException(ResultCode.OSS_DELETE_ERROR, e.getMessage());
        }
    }

    @Override
    public String uploadAndGetDownloadUrl(InputStream inputStream, String fileName) {
        return null;
    }

    @Override
    public String inputStreamUpload(InputStream inputStream, String key) {
        String bucket = "";
        try {
            MinioClient client = this.getOssClient();
            bucket = this.ossSetting.getM_bucketName();
            PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).stream(inputStream, (long)inputStream.available(), 0x500000L).object(key)).contentType("image/png").build();
            client.putObject(putObjectArgs);
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u5931\u8d252\uff0c", (Throwable)e);
            throw new ServiceException(ResultCode.OSS_DELETE_ERROR, e.getMessage());
        }
        return this.ossSetting.getM_frontUrl() + "/" + bucket + "/" + key;
    }

    @Override
    public void deleteFile(List<String> key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        MinioClient ossClient = this.getOssClient();
        List objectList = key.stream().map(DeleteObject::new).collect(Collectors.toList());
        ossClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().objects(objectList).bucket(this.ossSetting.getM_bucketName())).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MinioClient getOssClient() {
        if (this.minioClient != null) {
            return this.minioClient;
        }
        MinioFilePlugin minioFilePlugin = this;
        synchronized (minioFilePlugin) {
            if (this.minioClient == null) {
                this.minioClient = MinioClient.builder().endpoint(this.ossSetting.getM_endpoint()).credentials(this.ossSetting.getM_accessKey(), this.ossSetting.getM_secretKey()).build();
                try {
                    if (!this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.ossSetting.getM_bucketName())).build())) {
                        MakeBucketArgs makeBucketArgs = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.ossSetting.getM_bucketName())).build();
                        this.minioClient.makeBucket(makeBucketArgs);
                        MinioFilePlugin.setBucketPolicy(this.minioClient, this.ossSetting.getM_bucketName(), "read-write");
                        log.info("\u521b\u5efaminio\u6876\u6210\u529f{}", (Object)this.ossSetting.getM_bucketName());
                    }
                }
                catch (Exception e) {
                    this.minioClient = null;
                    log.error("\u521b\u5efa[{}]bucket\u5931\u8d25", (Object)this.ossSetting.getM_bucketName());
                    throw new ServiceException(ResultCode.OSS_DELETE_ERROR, e.getMessage());
                }
            }
        }
        return this.minioClient;
    }

    public static void setBucketPolicy(MinioClient client, String bucket, String policy) throws Exception {
        switch (policy) {
            case "read-only": {
                client.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucket)).config(READ_ONLY.replace(BUCKET_PARAM, bucket)).build());
                break;
            }
            case "write-only": {
                client.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucket)).config(WRITE_ONLY.replace(BUCKET_PARAM, bucket)).build());
                break;
            }
            case "read-write": {
                client.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucket)).region("public")).config(READ_WRITE.replace(BUCKET_PARAM, bucket)).build());
                break;
            }
        }
    }
}

