/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.file.serviceimpl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.security.AuthUser;
import cn.lili.common.vo.PageVO;
import cn.lili.common.vo.SearchVO;
import cn.lili.modules.file.entity.File;
import cn.lili.modules.file.entity.dto.FileOwnerDTO;
import cn.lili.modules.file.mapper.FileMapper;
import cn.lili.modules.file.plugin.FilePluginFactory;
import cn.lili.modules.file.service.FileService;
import cn.lili.mybatis.BaseEntity;
import cn.lili.mybatis.util.PageUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
extends ServiceImpl<FileMapper, File>
implements FileService {
    @Autowired
    private FilePluginFactory filePluginFactory;

    @Override
    public void batchDelete(List<String> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BaseEntity::getId, ids);
        List files = this.list((Wrapper)queryWrapper);
        ArrayList<String> keys = new ArrayList<String>();
        files.forEach(item -> keys.add(item.getFileKey()));
        this.filePluginFactory.filePlugin().deleteFile(keys);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void batchDelete(List<String> ids, AuthUser authUser) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BaseEntity::getId, ids);
        queryWrapper.eq(File::getUserEnums, (Object)authUser.getRole().name());
        switch (authUser.getRole()) {
            case MEMBER: {
                queryWrapper.eq(File::getOwnerId, (Object)authUser.getId());
                break;
            }
            case STORE: {
                queryWrapper.eq(File::getOwnerId, (Object)authUser.getStoreId());
                break;
            }
            case MANAGER: {
                break;
            }
            default: {
                throw new ServiceException(ResultCode.USER_AUTHORITY_ERROR);
            }
        }
        List files = this.list((Wrapper)queryWrapper);
        ArrayList<String> keys = new ArrayList<String>();
        files.forEach(item -> keys.add(item.getFileKey()));
        this.filePluginFactory.filePlugin().deleteFile(keys);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public IPage<File> customerPage(File file, SearchVO searchVO, PageVO pageVo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(CharSequenceUtil.isNotEmpty((CharSequence)file.getName()), File::getName, (Object)file.getName())).like(CharSequenceUtil.isNotEmpty((CharSequence)file.getFileKey()), File::getFileKey, (Object)file.getFileKey())).like(CharSequenceUtil.isNotEmpty((CharSequence)file.getFileType()), File::getFileType, (Object)file.getFileType())).between(CharSequenceUtil.isNotEmpty((CharSequence)searchVO.getStartDate()) && CharSequenceUtil.isNotEmpty((CharSequence)searchVO.getEndDate()), BaseEntity::getCreateTime, (Object)searchVO.getStartDate(), (Object)searchVO.getEndDate());
        return this.page((IPage)PageUtil.initPage((PageVO)pageVo), (Wrapper)queryWrapper);
    }

    @Override
    public IPage<File> customerPageOwner(FileOwnerDTO ownerDTO, File file, SearchVO searchVO, PageVO pageVo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(CharSequenceUtil.isNotEmpty((CharSequence)ownerDTO.getOwnerId()), File::getOwnerId, (Object)ownerDTO.getOwnerId())).eq(File::getUserEnums, (Object)ownerDTO.getUserEnums())).like(CharSequenceUtil.isNotEmpty((CharSequence)file.getName()), File::getName, (Object)file.getName())).like(CharSequenceUtil.isNotEmpty((CharSequence)file.getFileKey()), File::getFileKey, (Object)file.getFileKey())).like(CharSequenceUtil.isNotEmpty((CharSequence)file.getFileType()), File::getFileType, (Object)file.getFileType())).between(CharSequenceUtil.isNotEmpty((CharSequence)searchVO.getStartDate()) && CharSequenceUtil.isNotEmpty((CharSequence)searchVO.getEndDate()), BaseEntity::getCreateTime, (Object)searchVO.getStartDate(), (Object)searchVO.getEndDate());
        return this.page((IPage)PageUtil.initPage((PageVO)pageVo), (Wrapper)queryWrapper);
    }
}

