/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.goods.client;

import cn.lili.cache.CachePrefix;
import cn.lili.modules.goods.entity.dos.GoodsSku;
import cn.lili.modules.goods.fallback.GoodsSkuFallback;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="goods-service", contextId="goods-sku", fallback=GoodsSkuFallback.class)
public interface GoodsSkuClient {
    @GetMapping(value={"/feign/goods/goods-sku/getStockCacheKey"})
    public static String getStockCacheKey(@RequestParam String id) {
        return CachePrefix.SKU_STOCK.getPrefix() + id;
    }

    @GetMapping(value={"/feign/goods/goods-sku/getGoodsSkuByIdFromCache"})
    public GoodsSku getGoodsSkuByIdFromCache(@RequestParam String var1);

    @PostMapping(value={"/feign/goods/goods-sku/getGoodsSkuByIdFromCache"})
    public List<GoodsSku> getGoodsSkuByIdFromCache(@RequestBody List<String> var1);

    @GetMapping(value={"/feign/goods/goods-sku/getStock"})
    public Integer getStock(@RequestParam String var1);

    @PutMapping(value={"/feign/goods/goods-sku/updateGoodsStuck"})
    public void updateGoodsStuck(@RequestBody List<GoodsSku> var1);

    @PutMapping(value={"/feign/goods/goods-sku/updateGoodsSkuCommentNum"})
    public void updateGoodsSkuCommentNum(@RequestParam String var1);

    @PutMapping(value={"/feign/goods/goods-sku/updateBatchById"})
    public void updateBatchById(@RequestBody List<GoodsSku> var1);

    @GetMapping(value={"/feign/goods/goods-sku/getStockWarningGoods"})
    public List<GoodsSku> getStockWarningGoods(@RequestParam Integer var1, @RequestParam String var2);
}

