/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.goods.entity.dos;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.http.HtmlUtil;
import cn.hutool.json.JSONUtil;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.goods.entity.dto.DraftGoodsDTO;
import cn.lili.modules.goods.entity.dto.GoodsOperationDTO;
import cn.lili.modules.goods.entity.enums.GoodsSalesModeEnum;
import cn.lili.modules.goods.entity.enums.GoodsStatusEnum;
import cn.lili.modules.goods.entity.enums.GoodsTypeEnum;
import cn.lili.mybatis.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.xkcoding.http.util.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@TableName(value="li_goods")
@ApiModel(value="\u5546\u54c1")
public class Goods
extends BaseEntity {
    private static final long serialVersionUID = 370683495251252601L;
    @ApiModelProperty(value="\u5546\u54c1\u540d\u79f0")
    @NotEmpty(message="\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=100, message="\u5546\u54c1\u540d\u79f0\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26")
    private @NotEmpty(message="\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=100, message="\u5546\u54c1\u540d\u79f0\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26") String goodsName;
    @ApiModelProperty(value="\u5546\u54c1\u4ef7\u683c", required=true)
    @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a")
    @Min(value=0L, message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u8d1f\u6570")
    @Max(value=99999999L, message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u8d85\u8fc799999999")
    private @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=0L, message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u8d1f\u6570") @Max(value=99999999L, message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u8d85\u8fc799999999") Double price;
    @ApiModelProperty(value="\u54c1\u724cid")
    private String brandId;
    @ApiModelProperty(value="\u5206\u7c7bpath")
    private String categoryPath;
    @ApiModelProperty(value="\u8ba1\u91cf\u5355\u4f4d")
    private String goodsUnit;
    @Length(max=60, message="\u5546\u54c1\u5356\u70b9\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc760\u4e2a\u5b57\u7b26")
    @ApiModelProperty(value="\u5356\u70b9")
    private @Length(max=60, message="\u5546\u54c1\u5356\u70b9\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc760\u4e2a\u5b57\u7b26") String sellingPoint;
    @ApiModelProperty(value="\u4e0a\u67b6\u72b6\u6001")
    private String marketEnable;
    @ApiModelProperty(value="\u8be6\u60c5")
    private String intro;
    @ApiModelProperty(value="\u8d2d\u4e70\u6570\u91cf")
    private Integer buyCount;
    @Max(value=99999999L, message="\u5e93\u5b58\u4e0d\u80fd\u8d85\u8fc799999999")
    @ApiModelProperty(value="\u5e93\u5b58")
    private @Max(value=99999999L, message="\u5e93\u5b58\u4e0d\u80fd\u8d85\u8fc799999999") Integer quantity;
    @ApiModelProperty(value="\u5546\u54c1\u597d\u8bc4\u7387")
    private Double grade;
    @ApiModelProperty(value="\u7f29\u7565\u56fe\u8def\u5f84")
    private String thumbnail;
    @ApiModelProperty(value="\u5c0f\u56fe\u8def\u5f84")
    private String small;
    @ApiModelProperty(value="\u539f\u56fe\u8def\u5f84")
    private String original;
    @ApiModelProperty(value="\u5e97\u94fa\u5206\u7c7bid")
    private String storeCategoryPath;
    @ApiModelProperty(value="\u8bc4\u8bba\u6570\u91cf")
    private Integer commentNum;
    @ApiModelProperty(value="\u5356\u5bb6id")
    private String storeId;
    @ApiModelProperty(value="\u5356\u5bb6\u540d\u5b57")
    private String storeName;
    @ApiModelProperty(value="\u8fd0\u8d39\u6a21\u677fid")
    private String templateId;
    @ApiModelProperty(value="\u5ba1\u6838\u72b6\u6001")
    private String authFlag;
    @ApiModelProperty(value="\u5ba1\u6838\u4fe1\u606f")
    private String authMessage;
    @ApiModelProperty(value="\u4e0b\u67b6\u539f\u56e0")
    private String underMessage;
    @ApiModelProperty(value="\u662f\u5426\u81ea\u8425")
    private Boolean selfOperated;
    @ApiModelProperty(value="\u5546\u54c1\u79fb\u52a8\u7aef\u8be6\u60c5")
    private String mobileIntro;
    @ApiModelProperty(value="\u5546\u54c1\u89c6\u9891")
    private String goodsVideo;
    @ApiModelProperty(value="\u662f\u5426\u4e3a\u63a8\u8350\u5546\u54c1", required=true)
    private Boolean recommend;
    @ApiModelProperty(value="\u9500\u552e\u6a21\u5f0f", required=true)
    private String salesModel;
    @ApiModelProperty(value="\u5546\u54c1\u7c7b\u578b", required=true)
    private String goodsType;
    @ApiModelProperty(value="\u5546\u54c1\u53c2\u6570json", hidden=true)
    private String params;
    private String remark;
    @ApiModelProperty(value="\u5546\u54c1\u4e3b\u56fe")
    private String goodsGalleryImages;
    private String goodsDetailImages;
    @TableField(exist=false)
    private List<String> goodsGalleryImagesList;
    @TableField(exist=false)
    private List<String> goodsDetailImagesList;

    public Goods() {
    }

    public Goods(GoodsOperationDTO goodsOperationDTO) {
        this.goodsName = goodsOperationDTO.getGoodsName();
        this.categoryPath = goodsOperationDTO.getCategoryPath();
        this.storeCategoryPath = goodsOperationDTO.getStoreCategoryPath();
        this.brandId = goodsOperationDTO.getBrandId();
        this.templateId = goodsOperationDTO.getTemplateId();
        this.recommend = goodsOperationDTO.getRecommend();
        this.sellingPoint = goodsOperationDTO.getSellingPoint();
        this.salesModel = goodsOperationDTO.getSalesModel();
        this.goodsUnit = goodsOperationDTO.getGoodsUnit();
        this.intro = goodsOperationDTO.getIntro();
        this.mobileIntro = goodsOperationDTO.getMobileIntro();
        this.goodsVideo = goodsOperationDTO.getGoodsVideo();
        this.price = goodsOperationDTO.getPrice();
        if (goodsOperationDTO.getGoodsParamsDTOList() != null && !goodsOperationDTO.getGoodsParamsDTOList().isEmpty()) {
            this.params = JSONUtil.toJsonStr(goodsOperationDTO.getGoodsParamsDTOList());
        }
        this.marketEnable = Boolean.TRUE.equals(goodsOperationDTO.getRelease()) ? GoodsStatusEnum.UPPER.name() : GoodsStatusEnum.DOWN.name();
        this.goodsType = goodsOperationDTO.getGoodsType();
        this.grade = 100.0;
        for (Map<String, Object> sku : goodsOperationDTO.getSkuList()) {
            if (!sku.containsKey("sn") || sku.get("sn") == null) {
                throw new ServiceException(ResultCode.GOODS_SKU_SN_ERROR);
            }
            if ((!sku.containsKey("price") || StringUtil.isEmpty((String)sku.get("price").toString()) || Convert.toDouble((Object)sku.get("price")) <= 0.0) && !goodsOperationDTO.getSalesModel().equals(GoodsSalesModeEnum.WHOLESALE.name())) {
                throw new ServiceException(ResultCode.GOODS_SKU_PRICE_ERROR);
            }
            if ((!sku.containsKey("cost") || StringUtil.isEmpty((String)sku.get("cost").toString()) || Convert.toDouble((Object)sku.get("cost")) <= 0.0) && !goodsOperationDTO.getSalesModel().equals(GoodsSalesModeEnum.WHOLESALE.name())) {
                throw new ServiceException(ResultCode.GOODS_SKU_COST_ERROR);
            }
            if (this.goodsType.equals(GoodsTypeEnum.PHYSICAL_GOODS.name()) && (!sku.containsKey("weight") || sku.containsKey("weight") && (StringUtil.isEmpty((String)sku.get("weight").toString()) || Convert.toDouble((Object)sku.get("weight").toString()) < 0.0))) {
                throw new ServiceException(ResultCode.GOODS_SKU_WEIGHT_ERROR);
            }
            sku.values().forEach(i -> {
                if (CharSequenceUtil.isBlank((CharSequence)i.toString())) {
                    throw new ServiceException(ResultCode.MUST_HAVE_GOODS_SKU_VALUE);
                }
            });
        }
    }

    public Goods(DraftGoodsDTO goodsDTO) {
        this.goodsName = goodsDTO.getGoodsName();
        this.categoryPath = goodsDTO.getCategoryPath();
        this.storeCategoryPath = goodsDTO.getStoreCategoryPath();
        this.brandId = goodsDTO.getBrandId();
        this.templateId = goodsDTO.getTemplateId();
        this.recommend = goodsDTO.getRecommend();
        this.sellingPoint = goodsDTO.getSellingPoint();
        this.salesModel = goodsDTO.getSalesModel();
        this.goodsUnit = goodsDTO.getGoodsUnit();
        this.intro = goodsDTO.getIntro();
        this.mobileIntro = goodsDTO.getMobileIntro();
        this.goodsVideo = goodsDTO.getGoodsVideo();
        this.price = goodsDTO.getPrice();
        if (goodsDTO.getGoodsParamsDTOList() != null && goodsDTO.getGoodsParamsDTOList().isEmpty()) {
            this.params = JSONUtil.toJsonStr(goodsDTO.getGoodsParamsDTOList());
        }
        this.marketEnable = GoodsStatusEnum.DOWN.name();
        this.goodsType = goodsDTO.getGoodsType();
        this.grade = 100.0;
    }

    public String getIntro() {
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.intro)) {
            return HtmlUtil.unescape((String)this.intro);
        }
        return this.intro;
    }

    public String getMobileIntro() {
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.mobileIntro)) {
            return HtmlUtil.unescape((String)this.mobileIntro);
        }
        return this.mobileIntro;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Goods)) {
            return false;
        }
        Goods other = (Goods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Integer this$buyCount = this.getBuyCount();
        Integer other$buyCount = other.getBuyCount();
        if (this$buyCount == null ? other$buyCount != null : !((Object)this$buyCount).equals(other$buyCount)) {
            return false;
        }
        Integer this$quantity = this.getQuantity();
        Integer other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Double this$grade = this.getGrade();
        Double other$grade = other.getGrade();
        if (this$grade == null ? other$grade != null : !((Object)this$grade).equals(other$grade)) {
            return false;
        }
        Integer this$commentNum = this.getCommentNum();
        Integer other$commentNum = other.getCommentNum();
        if (this$commentNum == null ? other$commentNum != null : !((Object)this$commentNum).equals(other$commentNum)) {
            return false;
        }
        Boolean this$selfOperated = this.getSelfOperated();
        Boolean other$selfOperated = other.getSelfOperated();
        if (this$selfOperated == null ? other$selfOperated != null : !((Object)this$selfOperated).equals(other$selfOperated)) {
            return false;
        }
        Boolean this$recommend = this.getRecommend();
        Boolean other$recommend = other.getRecommend();
        if (this$recommend == null ? other$recommend != null : !((Object)this$recommend).equals(other$recommend)) {
            return false;
        }
        String this$goodsName = this.getGoodsName();
        String other$goodsName = other.getGoodsName();
        if (this$goodsName == null ? other$goodsName != null : !this$goodsName.equals(other$goodsName)) {
            return false;
        }
        String this$brandId = this.getBrandId();
        String other$brandId = other.getBrandId();
        if (this$brandId == null ? other$brandId != null : !this$brandId.equals(other$brandId)) {
            return false;
        }
        String this$categoryPath = this.getCategoryPath();
        String other$categoryPath = other.getCategoryPath();
        if (this$categoryPath == null ? other$categoryPath != null : !this$categoryPath.equals(other$categoryPath)) {
            return false;
        }
        String this$goodsUnit = this.getGoodsUnit();
        String other$goodsUnit = other.getGoodsUnit();
        if (this$goodsUnit == null ? other$goodsUnit != null : !this$goodsUnit.equals(other$goodsUnit)) {
            return false;
        }
        String this$sellingPoint = this.getSellingPoint();
        String other$sellingPoint = other.getSellingPoint();
        if (this$sellingPoint == null ? other$sellingPoint != null : !this$sellingPoint.equals(other$sellingPoint)) {
            return false;
        }
        String this$marketEnable = this.getMarketEnable();
        String other$marketEnable = other.getMarketEnable();
        if (this$marketEnable == null ? other$marketEnable != null : !this$marketEnable.equals(other$marketEnable)) {
            return false;
        }
        String this$intro = this.getIntro();
        String other$intro = other.getIntro();
        if (this$intro == null ? other$intro != null : !this$intro.equals(other$intro)) {
            return false;
        }
        String this$thumbnail = this.getThumbnail();
        String other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !this$thumbnail.equals(other$thumbnail)) {
            return false;
        }
        String this$small = this.getSmall();
        String other$small = other.getSmall();
        if (this$small == null ? other$small != null : !this$small.equals(other$small)) {
            return false;
        }
        String this$original = this.getOriginal();
        String other$original = other.getOriginal();
        if (this$original == null ? other$original != null : !this$original.equals(other$original)) {
            return false;
        }
        String this$storeCategoryPath = this.getStoreCategoryPath();
        String other$storeCategoryPath = other.getStoreCategoryPath();
        if (this$storeCategoryPath == null ? other$storeCategoryPath != null : !this$storeCategoryPath.equals(other$storeCategoryPath)) {
            return false;
        }
        String this$storeId = this.getStoreId();
        String other$storeId = other.getStoreId();
        if (this$storeId == null ? other$storeId != null : !this$storeId.equals(other$storeId)) {
            return false;
        }
        String this$storeName = this.getStoreName();
        String other$storeName = other.getStoreName();
        if (this$storeName == null ? other$storeName != null : !this$storeName.equals(other$storeName)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        String this$authFlag = this.getAuthFlag();
        String other$authFlag = other.getAuthFlag();
        if (this$authFlag == null ? other$authFlag != null : !this$authFlag.equals(other$authFlag)) {
            return false;
        }
        String this$authMessage = this.getAuthMessage();
        String other$authMessage = other.getAuthMessage();
        if (this$authMessage == null ? other$authMessage != null : !this$authMessage.equals(other$authMessage)) {
            return false;
        }
        String this$underMessage = this.getUnderMessage();
        String other$underMessage = other.getUnderMessage();
        if (this$underMessage == null ? other$underMessage != null : !this$underMessage.equals(other$underMessage)) {
            return false;
        }
        String this$mobileIntro = this.getMobileIntro();
        String other$mobileIntro = other.getMobileIntro();
        if (this$mobileIntro == null ? other$mobileIntro != null : !this$mobileIntro.equals(other$mobileIntro)) {
            return false;
        }
        String this$goodsVideo = this.getGoodsVideo();
        String other$goodsVideo = other.getGoodsVideo();
        if (this$goodsVideo == null ? other$goodsVideo != null : !this$goodsVideo.equals(other$goodsVideo)) {
            return false;
        }
        String this$salesModel = this.getSalesModel();
        String other$salesModel = other.getSalesModel();
        if (this$salesModel == null ? other$salesModel != null : !this$salesModel.equals(other$salesModel)) {
            return false;
        }
        String this$goodsType = this.getGoodsType();
        String other$goodsType = other.getGoodsType();
        if (this$goodsType == null ? other$goodsType != null : !this$goodsType.equals(other$goodsType)) {
            return false;
        }
        String this$params = this.getParams();
        String other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$goodsGalleryImages = this.getGoodsGalleryImages();
        String other$goodsGalleryImages = other.getGoodsGalleryImages();
        if (this$goodsGalleryImages == null ? other$goodsGalleryImages != null : !this$goodsGalleryImages.equals(other$goodsGalleryImages)) {
            return false;
        }
        String this$goodsDetailImages = this.getGoodsDetailImages();
        String other$goodsDetailImages = other.getGoodsDetailImages();
        if (this$goodsDetailImages == null ? other$goodsDetailImages != null : !this$goodsDetailImages.equals(other$goodsDetailImages)) {
            return false;
        }
        List<String> this$goodsGalleryImagesList = this.getGoodsGalleryImagesList();
        List<String> other$goodsGalleryImagesList = other.getGoodsGalleryImagesList();
        if (this$goodsGalleryImagesList == null ? other$goodsGalleryImagesList != null : !((Object)this$goodsGalleryImagesList).equals(other$goodsGalleryImagesList)) {
            return false;
        }
        List<String> this$goodsDetailImagesList = this.getGoodsDetailImagesList();
        List<String> other$goodsDetailImagesList = other.getGoodsDetailImagesList();
        return !(this$goodsDetailImagesList == null ? other$goodsDetailImagesList != null : !((Object)this$goodsDetailImagesList).equals(other$goodsDetailImagesList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Goods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Integer $buyCount = this.getBuyCount();
        result = result * 59 + ($buyCount == null ? 43 : ((Object)$buyCount).hashCode());
        Integer $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Double $grade = this.getGrade();
        result = result * 59 + ($grade == null ? 43 : ((Object)$grade).hashCode());
        Integer $commentNum = this.getCommentNum();
        result = result * 59 + ($commentNum == null ? 43 : ((Object)$commentNum).hashCode());
        Boolean $selfOperated = this.getSelfOperated();
        result = result * 59 + ($selfOperated == null ? 43 : ((Object)$selfOperated).hashCode());
        Boolean $recommend = this.getRecommend();
        result = result * 59 + ($recommend == null ? 43 : ((Object)$recommend).hashCode());
        String $goodsName = this.getGoodsName();
        result = result * 59 + ($goodsName == null ? 43 : $goodsName.hashCode());
        String $brandId = this.getBrandId();
        result = result * 59 + ($brandId == null ? 43 : $brandId.hashCode());
        String $categoryPath = this.getCategoryPath();
        result = result * 59 + ($categoryPath == null ? 43 : $categoryPath.hashCode());
        String $goodsUnit = this.getGoodsUnit();
        result = result * 59 + ($goodsUnit == null ? 43 : $goodsUnit.hashCode());
        String $sellingPoint = this.getSellingPoint();
        result = result * 59 + ($sellingPoint == null ? 43 : $sellingPoint.hashCode());
        String $marketEnable = this.getMarketEnable();
        result = result * 59 + ($marketEnable == null ? 43 : $marketEnable.hashCode());
        String $intro = this.getIntro();
        result = result * 59 + ($intro == null ? 43 : $intro.hashCode());
        String $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : $thumbnail.hashCode());
        String $small = this.getSmall();
        result = result * 59 + ($small == null ? 43 : $small.hashCode());
        String $original = this.getOriginal();
        result = result * 59 + ($original == null ? 43 : $original.hashCode());
        String $storeCategoryPath = this.getStoreCategoryPath();
        result = result * 59 + ($storeCategoryPath == null ? 43 : $storeCategoryPath.hashCode());
        String $storeId = this.getStoreId();
        result = result * 59 + ($storeId == null ? 43 : $storeId.hashCode());
        String $storeName = this.getStoreName();
        result = result * 59 + ($storeName == null ? 43 : $storeName.hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        String $authFlag = this.getAuthFlag();
        result = result * 59 + ($authFlag == null ? 43 : $authFlag.hashCode());
        String $authMessage = this.getAuthMessage();
        result = result * 59 + ($authMessage == null ? 43 : $authMessage.hashCode());
        String $underMessage = this.getUnderMessage();
        result = result * 59 + ($underMessage == null ? 43 : $underMessage.hashCode());
        String $mobileIntro = this.getMobileIntro();
        result = result * 59 + ($mobileIntro == null ? 43 : $mobileIntro.hashCode());
        String $goodsVideo = this.getGoodsVideo();
        result = result * 59 + ($goodsVideo == null ? 43 : $goodsVideo.hashCode());
        String $salesModel = this.getSalesModel();
        result = result * 59 + ($salesModel == null ? 43 : $salesModel.hashCode());
        String $goodsType = this.getGoodsType();
        result = result * 59 + ($goodsType == null ? 43 : $goodsType.hashCode());
        String $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $goodsGalleryImages = this.getGoodsGalleryImages();
        result = result * 59 + ($goodsGalleryImages == null ? 43 : $goodsGalleryImages.hashCode());
        String $goodsDetailImages = this.getGoodsDetailImages();
        result = result * 59 + ($goodsDetailImages == null ? 43 : $goodsDetailImages.hashCode());
        List<String> $goodsGalleryImagesList = this.getGoodsGalleryImagesList();
        result = result * 59 + ($goodsGalleryImagesList == null ? 43 : ((Object)$goodsGalleryImagesList).hashCode());
        List<String> $goodsDetailImagesList = this.getGoodsDetailImagesList();
        result = result * 59 + ($goodsDetailImagesList == null ? 43 : ((Object)$goodsDetailImagesList).hashCode());
        return result;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") Double getPrice() {
        return this.price;
    }

    public String getBrandId() {
        return this.brandId;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public String getGoodsUnit() {
        return this.goodsUnit;
    }

    public String getSellingPoint() {
        return this.sellingPoint;
    }

    public String getMarketEnable() {
        return this.marketEnable;
    }

    public Integer getBuyCount() {
        return this.buyCount;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public Double getGrade() {
        return this.grade;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public String getSmall() {
        return this.small;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getStoreCategoryPath() {
        return this.storeCategoryPath;
    }

    public Integer getCommentNum() {
        return this.commentNum;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getAuthFlag() {
        return this.authFlag;
    }

    public String getAuthMessage() {
        return this.authMessage;
    }

    public String getUnderMessage() {
        return this.underMessage;
    }

    public Boolean getSelfOperated() {
        return this.selfOperated;
    }

    public String getGoodsVideo() {
        return this.goodsVideo;
    }

    public Boolean getRecommend() {
        return this.recommend;
    }

    public String getSalesModel() {
        return this.salesModel;
    }

    public String getGoodsType() {
        return this.goodsType;
    }

    public String getParams() {
        return this.params;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getGoodsGalleryImages() {
        return this.goodsGalleryImages;
    }

    public String getGoodsDetailImages() {
        return this.goodsDetailImages;
    }

    public List<String> getGoodsGalleryImagesList() {
        return this.goodsGalleryImagesList;
    }

    public List<String> getGoodsDetailImagesList() {
        return this.goodsDetailImagesList;
    }

    public Goods setGoodsName(String goodsName) {
        this.goodsName = goodsName;
        return this;
    }

    public Goods setPrice(@NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") Double price) {
        this.price = price;
        return this;
    }

    public Goods setBrandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    public Goods setCategoryPath(String categoryPath) {
        this.categoryPath = categoryPath;
        return this;
    }

    public Goods setGoodsUnit(String goodsUnit) {
        this.goodsUnit = goodsUnit;
        return this;
    }

    public Goods setSellingPoint(String sellingPoint) {
        this.sellingPoint = sellingPoint;
        return this;
    }

    public Goods setMarketEnable(String marketEnable) {
        this.marketEnable = marketEnable;
        return this;
    }

    public Goods setIntro(String intro) {
        this.intro = intro;
        return this;
    }

    public Goods setBuyCount(Integer buyCount) {
        this.buyCount = buyCount;
        return this;
    }

    public Goods setQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public Goods setGrade(Double grade) {
        this.grade = grade;
        return this;
    }

    public Goods setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public Goods setSmall(String small) {
        this.small = small;
        return this;
    }

    public Goods setOriginal(String original) {
        this.original = original;
        return this;
    }

    public Goods setStoreCategoryPath(String storeCategoryPath) {
        this.storeCategoryPath = storeCategoryPath;
        return this;
    }

    public Goods setCommentNum(Integer commentNum) {
        this.commentNum = commentNum;
        return this;
    }

    public Goods setStoreId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    public Goods setStoreName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    public Goods setTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public Goods setAuthFlag(String authFlag) {
        this.authFlag = authFlag;
        return this;
    }

    public Goods setAuthMessage(String authMessage) {
        this.authMessage = authMessage;
        return this;
    }

    public Goods setUnderMessage(String underMessage) {
        this.underMessage = underMessage;
        return this;
    }

    public Goods setSelfOperated(Boolean selfOperated) {
        this.selfOperated = selfOperated;
        return this;
    }

    public Goods setMobileIntro(String mobileIntro) {
        this.mobileIntro = mobileIntro;
        return this;
    }

    public Goods setGoodsVideo(String goodsVideo) {
        this.goodsVideo = goodsVideo;
        return this;
    }

    public Goods setRecommend(Boolean recommend) {
        this.recommend = recommend;
        return this;
    }

    public Goods setSalesModel(String salesModel) {
        this.salesModel = salesModel;
        return this;
    }

    public Goods setGoodsType(String goodsType) {
        this.goodsType = goodsType;
        return this;
    }

    public Goods setParams(String params) {
        this.params = params;
        return this;
    }

    public Goods setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public Goods setGoodsGalleryImages(String goodsGalleryImages) {
        this.goodsGalleryImages = goodsGalleryImages;
        return this;
    }

    public Goods setGoodsDetailImages(String goodsDetailImages) {
        this.goodsDetailImages = goodsDetailImages;
        return this;
    }

    public Goods setGoodsGalleryImagesList(List<String> goodsGalleryImagesList) {
        this.goodsGalleryImagesList = goodsGalleryImagesList;
        return this;
    }

    public Goods setGoodsDetailImagesList(List<String> goodsDetailImagesList) {
        this.goodsDetailImagesList = goodsDetailImagesList;
        return this;
    }

    public String toString() {
        return "Goods(goodsName=" + this.getGoodsName() + ", price=" + this.getPrice() + ", brandId=" + this.getBrandId() + ", categoryPath=" + this.getCategoryPath() + ", goodsUnit=" + this.getGoodsUnit() + ", sellingPoint=" + this.getSellingPoint() + ", marketEnable=" + this.getMarketEnable() + ", intro=" + this.getIntro() + ", buyCount=" + this.getBuyCount() + ", quantity=" + this.getQuantity() + ", grade=" + this.getGrade() + ", thumbnail=" + this.getThumbnail() + ", small=" + this.getSmall() + ", original=" + this.getOriginal() + ", storeCategoryPath=" + this.getStoreCategoryPath() + ", commentNum=" + this.getCommentNum() + ", storeId=" + this.getStoreId() + ", storeName=" + this.getStoreName() + ", templateId=" + this.getTemplateId() + ", authFlag=" + this.getAuthFlag() + ", authMessage=" + this.getAuthMessage() + ", underMessage=" + this.getUnderMessage() + ", selfOperated=" + this.getSelfOperated() + ", mobileIntro=" + this.getMobileIntro() + ", goodsVideo=" + this.getGoodsVideo() + ", recommend=" + this.getRecommend() + ", salesModel=" + this.getSalesModel() + ", goodsType=" + this.getGoodsType() + ", params=" + this.getParams() + ", remark=" + this.getRemark() + ", goodsGalleryImages=" + this.getGoodsGalleryImages() + ", goodsDetailImages=" + this.getGoodsDetailImages() + ", goodsGalleryImagesList=" + this.getGoodsGalleryImagesList() + ", goodsDetailImagesList=" + this.getGoodsDetailImagesList() + ")";
    }
}

