/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.goods.entity.dto;

import cn.lili.common.validation.EnumValue;
import cn.lili.modules.goods.entity.dto.GoodsImportDTO;
import cn.lili.modules.goods.entity.dto.GoodsParamsDTO;
import cn.lili.modules.goods.entity.dto.WholesaleDTO;
import cn.lili.modules.goods.entity.enums.GoodsSalesModeEnum;
import cn.lili.modules.goods.entity.enums.GoodsTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Length;

public class GoodsOperationDTO
implements Serializable {
    private static final long serialVersionUID = -509667581371776913L;
    @ApiModelProperty(hidden=true)
    private String goodsId;
    @ApiModelProperty(value="\u5546\u54c1\u4ef7\u683c", required=true)
    @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a")
    @Min(value=0L, message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u8d1f\u6570")
    @Max(value=99999999L, message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u8d85\u8fc799999999")
    private @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=0L, message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u8d1f\u6570") @Max(value=99999999L, message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u8d85\u8fc799999999") Double price;
    @ApiModelProperty(value="\u5206\u7c7bpath")
    private String categoryPath;
    @ApiModelProperty(value="\u5e97\u94fa\u5206\u7c7bid", required=true)
    @Size(max=200, message="\u9009\u62e9\u4e86\u592a\u591a\u5e97\u94fa\u5206\u7c7b")
    private @Size(max=200, message="\u9009\u62e9\u4e86\u592a\u591a\u5e97\u94fa\u5206\u7c7b") String storeCategoryPath;
    @ApiModelProperty(value="\u54c1\u724cid")
    @Min(value=0L, message="\u54c1\u724c\u503c\u4e0d\u6b63\u786e")
    private @Min(value=0L, message="\u54c1\u724c\u503c\u4e0d\u6b63\u786e") String brandId;
    @ApiModelProperty(value="\u5546\u54c1\u540d\u79f0", required=true)
    @NotEmpty(message="\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=50, message="\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26")
    private @NotEmpty(message="\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=50, message="\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26") String goodsName;
    @ApiModelProperty(value="\u8be6\u60c5")
    private String intro;
    @ApiModelProperty(value="\u5546\u54c1\u79fb\u52a8\u7aef\u8be6\u60c5")
    private String mobileIntro;
    @ApiModelProperty(value="\u5e93\u5b58")
    @Min(value=0L, message="\u5e93\u5b58\u4e0d\u80fd\u4e3a\u8d1f\u6570")
    @Max(value=99999999L, message="\u5e93\u5b58\u4e0d\u80fd\u8d85\u8fc799999999")
    private @Min(value=0L, message="\u5e93\u5b58\u4e0d\u80fd\u4e3a\u8d1f\u6570") @Max(value=99999999L, message="\u5e93\u5b58\u4e0d\u80fd\u8d85\u8fc799999999") Integer quantity;
    @ApiModelProperty(value="\u662f\u5426\u7acb\u5373\u53d1\u5e03")
    private Boolean release;
    @ApiModelProperty(value="\u662f\u5426\u662f\u63a8\u8350\u5546\u54c1")
    private Boolean recommend;
    @ApiModelProperty(value="\u5546\u54c1\u53c2\u6570")
    private List<GoodsParamsDTO> goodsParamsDTOList;
    @ApiModelProperty(value="\u5546\u54c1\u56fe\u7247")
    private List<String> goodsGalleryList;
    @ApiModelProperty(value="\u8fd0\u8d39\u6a21\u677fid,\u4e0d\u9700\u8981\u8fd0\u8d39\u6a21\u677f\u65f6\u503c\u662f0", required=true)
    @NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0")
    @Min(value=0L, message="\u8fd0\u8d39\u6a21\u677f\u503c\u4e0d\u6b63\u786e")
    private @NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0") @Min(value=0L, message="\u8fd0\u8d39\u6a21\u677f\u503c\u4e0d\u6b63\u786e") String templateId;
    @ApiModelProperty(value="\u5356\u70b9")
    private String sellingPoint;
    @ApiModelProperty(value="\u9500\u552e\u6a21\u5f0f", required=true)
    private String salesModel;
    @ApiModelProperty(value="\u662f\u5426\u6709\u89c4\u683c", hidden=true)
    private String haveSpec;
    @ApiModelProperty(value="\u9500\u552e\u6a21\u5f0f", required=true)
    private String goodsUnit;
    @ApiModelProperty(value="\u5546\u54c1\u63cf\u8ff0")
    private String info;
    @ApiModelProperty(value="\u662f\u5426\u91cd\u65b0\u751f\u6210sku\u6570\u636e")
    private Boolean regeneratorSkuFlag = true;
    @ApiModelProperty(value="\u5546\u54c1\u7c7b\u578b")
    @EnumValue(strValues={"PHYSICAL_GOODS", "VIRTUAL_GOODS", "E_COUPON"}, message="\u5546\u54c1\u7c7b\u578b\u53c2\u6570\u503c\u9519\u8bef")
    private String goodsType;
    @ApiModelProperty(value="\u5546\u54c1\u89c6\u9891")
    private String goodsVideo;
    @ApiModelProperty(value="sku\u5217\u8868")
    @Valid
    private List<Map<String, Object>> skuList;
    @ApiModelProperty(value="\u662f\u5426\u4e3a\u5546\u54c1\u6a21\u7248")
    private Boolean goodsTemplateFlag = false;
    @ApiModelProperty(value="\u6279\u53d1\u5546\u54c1\u89c4\u5219")
    private List<WholesaleDTO> wholesaleList;
    @ApiModelProperty(value="\u6ce8\u610f\u4e8b\u9879")
    private String needingAttention;
    @ApiModelProperty(value="\u662f\u5426\u4e3a\u5e74\u5ea6\u4f1a\u5458\u4e13\u5c5e")
    private Boolean annualFeeExclusive;
    @ApiModelProperty(value="\u6d4f\u89c8\u6743\u9650")
    private String browsePermissions;

    public GoodsOperationDTO(GoodsImportDTO goodsImportDTO) {
        this.price = goodsImportDTO.getPrice();
        this.goodsName = goodsImportDTO.getGoodsName();
        this.intro = goodsImportDTO.getIntro();
        this.mobileIntro = goodsImportDTO.getIntro();
        this.quantity = goodsImportDTO.getQuantity();
        this.goodsGalleryList = goodsImportDTO.getGoodsGalleryList();
        this.templateId = goodsImportDTO.getTemplate();
        this.sellingPoint = goodsImportDTO.getSellingPoint();
        this.salesModel = GoodsSalesModeEnum.RETAIL.name();
        this.goodsUnit = goodsImportDTO.getGoodsUnit();
        this.goodsType = GoodsTypeEnum.PHYSICAL_GOODS.name();
        this.release = goodsImportDTO.getRelease();
        this.recommend = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sn", goodsImportDTO.getSn());
        map.put("price", goodsImportDTO.getPrice());
        map.put("cost", goodsImportDTO.getCost());
        map.put("weight", goodsImportDTO.getWeight());
        map.put("quantity", goodsImportDTO.getQuantity());
        map.put(goodsImportDTO.getSkuKey(), goodsImportDTO.getSkuValue());
        map.put("images", goodsImportDTO.getImages());
        ArrayList<Map<String, Object>> skuListNew = new ArrayList<Map<String, Object>>();
        skuListNew.add(map);
        this.skuList = skuListNew;
    }

    public String getGoodsName() {
        return this.goodsName.replace(",", "");
    }

    public static GoodsOperationDTOBuilder builder() {
        return new GoodsOperationDTOBuilder();
    }

    public String getGoodsId() {
        return this.goodsId;
    }

    @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") Double getPrice() {
        return this.price;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public String getStoreCategoryPath() {
        return this.storeCategoryPath;
    }

    public String getBrandId() {
        return this.brandId;
    }

    public String getIntro() {
        return this.intro;
    }

    public String getMobileIntro() {
        return this.mobileIntro;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public Boolean getRelease() {
        return this.release;
    }

    public Boolean getRecommend() {
        return this.recommend;
    }

    public List<GoodsParamsDTO> getGoodsParamsDTOList() {
        return this.goodsParamsDTOList;
    }

    public List<String> getGoodsGalleryList() {
        return this.goodsGalleryList;
    }

    @NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0")
    public @NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0") String getTemplateId() {
        return this.templateId;
    }

    public String getSellingPoint() {
        return this.sellingPoint;
    }

    public String getSalesModel() {
        return this.salesModel;
    }

    public String getHaveSpec() {
        return this.haveSpec;
    }

    public String getGoodsUnit() {
        return this.goodsUnit;
    }

    public String getInfo() {
        return this.info;
    }

    public Boolean getRegeneratorSkuFlag() {
        return this.regeneratorSkuFlag;
    }

    public String getGoodsType() {
        return this.goodsType;
    }

    public String getGoodsVideo() {
        return this.goodsVideo;
    }

    public List<Map<String, Object>> getSkuList() {
        return this.skuList;
    }

    public Boolean getGoodsTemplateFlag() {
        return this.goodsTemplateFlag;
    }

    public List<WholesaleDTO> getWholesaleList() {
        return this.wholesaleList;
    }

    public String getNeedingAttention() {
        return this.needingAttention;
    }

    public Boolean getAnnualFeeExclusive() {
        return this.annualFeeExclusive;
    }

    public String getBrowsePermissions() {
        return this.browsePermissions;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public void setPrice(@NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") Double price) {
        this.price = price;
    }

    public void setCategoryPath(String categoryPath) {
        this.categoryPath = categoryPath;
    }

    public void setStoreCategoryPath(String storeCategoryPath) {
        this.storeCategoryPath = storeCategoryPath;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public void setMobileIntro(String mobileIntro) {
        this.mobileIntro = mobileIntro;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public void setRelease(Boolean release) {
        this.release = release;
    }

    public void setRecommend(Boolean recommend) {
        this.recommend = recommend;
    }

    public void setGoodsParamsDTOList(List<GoodsParamsDTO> goodsParamsDTOList) {
        this.goodsParamsDTOList = goodsParamsDTOList;
    }

    public void setGoodsGalleryList(List<String> goodsGalleryList) {
        this.goodsGalleryList = goodsGalleryList;
    }

    public void setTemplateId(@NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0") @NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0") String templateId) {
        this.templateId = templateId;
    }

    public void setSellingPoint(String sellingPoint) {
        this.sellingPoint = sellingPoint;
    }

    public void setSalesModel(String salesModel) {
        this.salesModel = salesModel;
    }

    public void setHaveSpec(String haveSpec) {
        this.haveSpec = haveSpec;
    }

    public void setGoodsUnit(String goodsUnit) {
        this.goodsUnit = goodsUnit;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setRegeneratorSkuFlag(Boolean regeneratorSkuFlag) {
        this.regeneratorSkuFlag = regeneratorSkuFlag;
    }

    public void setGoodsType(String goodsType) {
        this.goodsType = goodsType;
    }

    public void setGoodsVideo(String goodsVideo) {
        this.goodsVideo = goodsVideo;
    }

    public void setSkuList(List<Map<String, Object>> skuList) {
        this.skuList = skuList;
    }

    public void setGoodsTemplateFlag(Boolean goodsTemplateFlag) {
        this.goodsTemplateFlag = goodsTemplateFlag;
    }

    public void setWholesaleList(List<WholesaleDTO> wholesaleList) {
        this.wholesaleList = wholesaleList;
    }

    public void setNeedingAttention(String needingAttention) {
        this.needingAttention = needingAttention;
    }

    public void setAnnualFeeExclusive(Boolean annualFeeExclusive) {
        this.annualFeeExclusive = annualFeeExclusive;
    }

    public void setBrowsePermissions(String browsePermissions) {
        this.browsePermissions = browsePermissions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GoodsOperationDTO)) {
            return false;
        }
        GoodsOperationDTO other = (GoodsOperationDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Integer this$quantity = this.getQuantity();
        Integer other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Boolean this$release = this.getRelease();
        Boolean other$release = other.getRelease();
        if (this$release == null ? other$release != null : !((Object)this$release).equals(other$release)) {
            return false;
        }
        Boolean this$recommend = this.getRecommend();
        Boolean other$recommend = other.getRecommend();
        if (this$recommend == null ? other$recommend != null : !((Object)this$recommend).equals(other$recommend)) {
            return false;
        }
        Boolean this$regeneratorSkuFlag = this.getRegeneratorSkuFlag();
        Boolean other$regeneratorSkuFlag = other.getRegeneratorSkuFlag();
        if (this$regeneratorSkuFlag == null ? other$regeneratorSkuFlag != null : !((Object)this$regeneratorSkuFlag).equals(other$regeneratorSkuFlag)) {
            return false;
        }
        Boolean this$goodsTemplateFlag = this.getGoodsTemplateFlag();
        Boolean other$goodsTemplateFlag = other.getGoodsTemplateFlag();
        if (this$goodsTemplateFlag == null ? other$goodsTemplateFlag != null : !((Object)this$goodsTemplateFlag).equals(other$goodsTemplateFlag)) {
            return false;
        }
        Boolean this$annualFeeExclusive = this.getAnnualFeeExclusive();
        Boolean other$annualFeeExclusive = other.getAnnualFeeExclusive();
        if (this$annualFeeExclusive == null ? other$annualFeeExclusive != null : !((Object)this$annualFeeExclusive).equals(other$annualFeeExclusive)) {
            return false;
        }
        String this$goodsId = this.getGoodsId();
        String other$goodsId = other.getGoodsId();
        if (this$goodsId == null ? other$goodsId != null : !this$goodsId.equals(other$goodsId)) {
            return false;
        }
        String this$categoryPath = this.getCategoryPath();
        String other$categoryPath = other.getCategoryPath();
        if (this$categoryPath == null ? other$categoryPath != null : !this$categoryPath.equals(other$categoryPath)) {
            return false;
        }
        String this$storeCategoryPath = this.getStoreCategoryPath();
        String other$storeCategoryPath = other.getStoreCategoryPath();
        if (this$storeCategoryPath == null ? other$storeCategoryPath != null : !this$storeCategoryPath.equals(other$storeCategoryPath)) {
            return false;
        }
        String this$brandId = this.getBrandId();
        String other$brandId = other.getBrandId();
        if (this$brandId == null ? other$brandId != null : !this$brandId.equals(other$brandId)) {
            return false;
        }
        String this$goodsName = this.getGoodsName();
        String other$goodsName = other.getGoodsName();
        if (this$goodsName == null ? other$goodsName != null : !this$goodsName.equals(other$goodsName)) {
            return false;
        }
        String this$intro = this.getIntro();
        String other$intro = other.getIntro();
        if (this$intro == null ? other$intro != null : !this$intro.equals(other$intro)) {
            return false;
        }
        String this$mobileIntro = this.getMobileIntro();
        String other$mobileIntro = other.getMobileIntro();
        if (this$mobileIntro == null ? other$mobileIntro != null : !this$mobileIntro.equals(other$mobileIntro)) {
            return false;
        }
        List<GoodsParamsDTO> this$goodsParamsDTOList = this.getGoodsParamsDTOList();
        List<GoodsParamsDTO> other$goodsParamsDTOList = other.getGoodsParamsDTOList();
        if (this$goodsParamsDTOList == null ? other$goodsParamsDTOList != null : !((Object)this$goodsParamsDTOList).equals(other$goodsParamsDTOList)) {
            return false;
        }
        List<String> this$goodsGalleryList = this.getGoodsGalleryList();
        List<String> other$goodsGalleryList = other.getGoodsGalleryList();
        if (this$goodsGalleryList == null ? other$goodsGalleryList != null : !((Object)this$goodsGalleryList).equals(other$goodsGalleryList)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        String this$sellingPoint = this.getSellingPoint();
        String other$sellingPoint = other.getSellingPoint();
        if (this$sellingPoint == null ? other$sellingPoint != null : !this$sellingPoint.equals(other$sellingPoint)) {
            return false;
        }
        String this$salesModel = this.getSalesModel();
        String other$salesModel = other.getSalesModel();
        if (this$salesModel == null ? other$salesModel != null : !this$salesModel.equals(other$salesModel)) {
            return false;
        }
        String this$haveSpec = this.getHaveSpec();
        String other$haveSpec = other.getHaveSpec();
        if (this$haveSpec == null ? other$haveSpec != null : !this$haveSpec.equals(other$haveSpec)) {
            return false;
        }
        String this$goodsUnit = this.getGoodsUnit();
        String other$goodsUnit = other.getGoodsUnit();
        if (this$goodsUnit == null ? other$goodsUnit != null : !this$goodsUnit.equals(other$goodsUnit)) {
            return false;
        }
        String this$info = this.getInfo();
        String other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        String this$goodsType = this.getGoodsType();
        String other$goodsType = other.getGoodsType();
        if (this$goodsType == null ? other$goodsType != null : !this$goodsType.equals(other$goodsType)) {
            return false;
        }
        String this$goodsVideo = this.getGoodsVideo();
        String other$goodsVideo = other.getGoodsVideo();
        if (this$goodsVideo == null ? other$goodsVideo != null : !this$goodsVideo.equals(other$goodsVideo)) {
            return false;
        }
        List<Map<String, Object>> this$skuList = this.getSkuList();
        List<Map<String, Object>> other$skuList = other.getSkuList();
        if (this$skuList == null ? other$skuList != null : !((Object)this$skuList).equals(other$skuList)) {
            return false;
        }
        List<WholesaleDTO> this$wholesaleList = this.getWholesaleList();
        List<WholesaleDTO> other$wholesaleList = other.getWholesaleList();
        if (this$wholesaleList == null ? other$wholesaleList != null : !((Object)this$wholesaleList).equals(other$wholesaleList)) {
            return false;
        }
        String this$needingAttention = this.getNeedingAttention();
        String other$needingAttention = other.getNeedingAttention();
        if (this$needingAttention == null ? other$needingAttention != null : !this$needingAttention.equals(other$needingAttention)) {
            return false;
        }
        String this$browsePermissions = this.getBrowsePermissions();
        String other$browsePermissions = other.getBrowsePermissions();
        return !(this$browsePermissions == null ? other$browsePermissions != null : !this$browsePermissions.equals(other$browsePermissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GoodsOperationDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Integer $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Boolean $release = this.getRelease();
        result = result * 59 + ($release == null ? 43 : ((Object)$release).hashCode());
        Boolean $recommend = this.getRecommend();
        result = result * 59 + ($recommend == null ? 43 : ((Object)$recommend).hashCode());
        Boolean $regeneratorSkuFlag = this.getRegeneratorSkuFlag();
        result = result * 59 + ($regeneratorSkuFlag == null ? 43 : ((Object)$regeneratorSkuFlag).hashCode());
        Boolean $goodsTemplateFlag = this.getGoodsTemplateFlag();
        result = result * 59 + ($goodsTemplateFlag == null ? 43 : ((Object)$goodsTemplateFlag).hashCode());
        Boolean $annualFeeExclusive = this.getAnnualFeeExclusive();
        result = result * 59 + ($annualFeeExclusive == null ? 43 : ((Object)$annualFeeExclusive).hashCode());
        String $goodsId = this.getGoodsId();
        result = result * 59 + ($goodsId == null ? 43 : $goodsId.hashCode());
        String $categoryPath = this.getCategoryPath();
        result = result * 59 + ($categoryPath == null ? 43 : $categoryPath.hashCode());
        String $storeCategoryPath = this.getStoreCategoryPath();
        result = result * 59 + ($storeCategoryPath == null ? 43 : $storeCategoryPath.hashCode());
        String $brandId = this.getBrandId();
        result = result * 59 + ($brandId == null ? 43 : $brandId.hashCode());
        String $goodsName = this.getGoodsName();
        result = result * 59 + ($goodsName == null ? 43 : $goodsName.hashCode());
        String $intro = this.getIntro();
        result = result * 59 + ($intro == null ? 43 : $intro.hashCode());
        String $mobileIntro = this.getMobileIntro();
        result = result * 59 + ($mobileIntro == null ? 43 : $mobileIntro.hashCode());
        List<GoodsParamsDTO> $goodsParamsDTOList = this.getGoodsParamsDTOList();
        result = result * 59 + ($goodsParamsDTOList == null ? 43 : ((Object)$goodsParamsDTOList).hashCode());
        List<String> $goodsGalleryList = this.getGoodsGalleryList();
        result = result * 59 + ($goodsGalleryList == null ? 43 : ((Object)$goodsGalleryList).hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        String $sellingPoint = this.getSellingPoint();
        result = result * 59 + ($sellingPoint == null ? 43 : $sellingPoint.hashCode());
        String $salesModel = this.getSalesModel();
        result = result * 59 + ($salesModel == null ? 43 : $salesModel.hashCode());
        String $haveSpec = this.getHaveSpec();
        result = result * 59 + ($haveSpec == null ? 43 : $haveSpec.hashCode());
        String $goodsUnit = this.getGoodsUnit();
        result = result * 59 + ($goodsUnit == null ? 43 : $goodsUnit.hashCode());
        String $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        String $goodsType = this.getGoodsType();
        result = result * 59 + ($goodsType == null ? 43 : $goodsType.hashCode());
        String $goodsVideo = this.getGoodsVideo();
        result = result * 59 + ($goodsVideo == null ? 43 : $goodsVideo.hashCode());
        List<Map<String, Object>> $skuList = this.getSkuList();
        result = result * 59 + ($skuList == null ? 43 : ((Object)$skuList).hashCode());
        List<WholesaleDTO> $wholesaleList = this.getWholesaleList();
        result = result * 59 + ($wholesaleList == null ? 43 : ((Object)$wholesaleList).hashCode());
        String $needingAttention = this.getNeedingAttention();
        result = result * 59 + ($needingAttention == null ? 43 : $needingAttention.hashCode());
        String $browsePermissions = this.getBrowsePermissions();
        result = result * 59 + ($browsePermissions == null ? 43 : $browsePermissions.hashCode());
        return result;
    }

    public String toString() {
        return "GoodsOperationDTO(goodsId=" + this.getGoodsId() + ", price=" + this.getPrice() + ", categoryPath=" + this.getCategoryPath() + ", storeCategoryPath=" + this.getStoreCategoryPath() + ", brandId=" + this.getBrandId() + ", goodsName=" + this.getGoodsName() + ", intro=" + this.getIntro() + ", mobileIntro=" + this.getMobileIntro() + ", quantity=" + this.getQuantity() + ", release=" + this.getRelease() + ", recommend=" + this.getRecommend() + ", goodsParamsDTOList=" + this.getGoodsParamsDTOList() + ", goodsGalleryList=" + this.getGoodsGalleryList() + ", templateId=" + this.getTemplateId() + ", sellingPoint=" + this.getSellingPoint() + ", salesModel=" + this.getSalesModel() + ", haveSpec=" + this.getHaveSpec() + ", goodsUnit=" + this.getGoodsUnit() + ", info=" + this.getInfo() + ", regeneratorSkuFlag=" + this.getRegeneratorSkuFlag() + ", goodsType=" + this.getGoodsType() + ", goodsVideo=" + this.getGoodsVideo() + ", skuList=" + this.getSkuList() + ", goodsTemplateFlag=" + this.getGoodsTemplateFlag() + ", wholesaleList=" + this.getWholesaleList() + ", needingAttention=" + this.getNeedingAttention() + ", annualFeeExclusive=" + this.getAnnualFeeExclusive() + ", browsePermissions=" + this.getBrowsePermissions() + ")";
    }

    public GoodsOperationDTO() {
    }

    public GoodsOperationDTO(String goodsId, @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") Double price, String categoryPath, String storeCategoryPath, String brandId, String goodsName, String intro, String mobileIntro, Integer quantity, Boolean release, Boolean recommend, List<GoodsParamsDTO> goodsParamsDTOList, List<String> goodsGalleryList, @NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0") @NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0") String templateId, String sellingPoint, String salesModel, String haveSpec, String goodsUnit, String info, Boolean regeneratorSkuFlag, String goodsType, String goodsVideo, List<Map<String, Object>> skuList, Boolean goodsTemplateFlag, List<WholesaleDTO> wholesaleList, String needingAttention, Boolean annualFeeExclusive, String browsePermissions) {
        this.goodsId = goodsId;
        this.price = price;
        this.categoryPath = categoryPath;
        this.storeCategoryPath = storeCategoryPath;
        this.brandId = brandId;
        this.goodsName = goodsName;
        this.intro = intro;
        this.mobileIntro = mobileIntro;
        this.quantity = quantity;
        this.release = release;
        this.recommend = recommend;
        this.goodsParamsDTOList = goodsParamsDTOList;
        this.goodsGalleryList = goodsGalleryList;
        this.templateId = templateId;
        this.sellingPoint = sellingPoint;
        this.salesModel = salesModel;
        this.haveSpec = haveSpec;
        this.goodsUnit = goodsUnit;
        this.info = info;
        this.regeneratorSkuFlag = regeneratorSkuFlag;
        this.goodsType = goodsType;
        this.goodsVideo = goodsVideo;
        this.skuList = skuList;
        this.goodsTemplateFlag = goodsTemplateFlag;
        this.wholesaleList = wholesaleList;
        this.needingAttention = needingAttention;
        this.annualFeeExclusive = annualFeeExclusive;
        this.browsePermissions = browsePermissions;
    }

    public static class GoodsOperationDTOBuilder {
        private String goodsId;
        private Double price;
        private String categoryPath;
        private String storeCategoryPath;
        private String brandId;
        private String goodsName;
        private String intro;
        private String mobileIntro;
        private Integer quantity;
        private Boolean release;
        private Boolean recommend;
        private List<GoodsParamsDTO> goodsParamsDTOList;
        private List<String> goodsGalleryList;
        private String templateId;
        private String sellingPoint;
        private String salesModel;
        private String haveSpec;
        private String goodsUnit;
        private String info;
        private Boolean regeneratorSkuFlag;
        private String goodsType;
        private String goodsVideo;
        private List<Map<String, Object>> skuList;
        private Boolean goodsTemplateFlag;
        private List<WholesaleDTO> wholesaleList;
        private String needingAttention;
        private Boolean annualFeeExclusive;
        private String browsePermissions;

        GoodsOperationDTOBuilder() {
        }

        public GoodsOperationDTOBuilder goodsId(String goodsId) {
            this.goodsId = goodsId;
            return this;
        }

        public GoodsOperationDTOBuilder price(@NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a") Double price) {
            this.price = price;
            return this;
        }

        public GoodsOperationDTOBuilder categoryPath(String categoryPath) {
            this.categoryPath = categoryPath;
            return this;
        }

        public GoodsOperationDTOBuilder storeCategoryPath(String storeCategoryPath) {
            this.storeCategoryPath = storeCategoryPath;
            return this;
        }

        public GoodsOperationDTOBuilder brandId(String brandId) {
            this.brandId = brandId;
            return this;
        }

        public GoodsOperationDTOBuilder goodsName(String goodsName) {
            this.goodsName = goodsName;
            return this;
        }

        public GoodsOperationDTOBuilder intro(String intro) {
            this.intro = intro;
            return this;
        }

        public GoodsOperationDTOBuilder mobileIntro(String mobileIntro) {
            this.mobileIntro = mobileIntro;
            return this;
        }

        public GoodsOperationDTOBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public GoodsOperationDTOBuilder release(Boolean release) {
            this.release = release;
            return this;
        }

        public GoodsOperationDTOBuilder recommend(Boolean recommend) {
            this.recommend = recommend;
            return this;
        }

        public GoodsOperationDTOBuilder goodsParamsDTOList(List<GoodsParamsDTO> goodsParamsDTOList) {
            this.goodsParamsDTOList = goodsParamsDTOList;
            return this;
        }

        public GoodsOperationDTOBuilder goodsGalleryList(List<String> goodsGalleryList) {
            this.goodsGalleryList = goodsGalleryList;
            return this;
        }

        public GoodsOperationDTOBuilder templateId(@NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0") @NotNull(message="\u8fd0\u8d39\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8fd0\u8d39\u6a21\u677f\u65f6\uff0c\u4f20\u503c0") String templateId) {
            this.templateId = templateId;
            return this;
        }

        public GoodsOperationDTOBuilder sellingPoint(String sellingPoint) {
            this.sellingPoint = sellingPoint;
            return this;
        }

        public GoodsOperationDTOBuilder salesModel(String salesModel) {
            this.salesModel = salesModel;
            return this;
        }

        public GoodsOperationDTOBuilder haveSpec(String haveSpec) {
            this.haveSpec = haveSpec;
            return this;
        }

        public GoodsOperationDTOBuilder goodsUnit(String goodsUnit) {
            this.goodsUnit = goodsUnit;
            return this;
        }

        public GoodsOperationDTOBuilder info(String info) {
            this.info = info;
            return this;
        }

        public GoodsOperationDTOBuilder regeneratorSkuFlag(Boolean regeneratorSkuFlag) {
            this.regeneratorSkuFlag = regeneratorSkuFlag;
            return this;
        }

        public GoodsOperationDTOBuilder goodsType(String goodsType) {
            this.goodsType = goodsType;
            return this;
        }

        public GoodsOperationDTOBuilder goodsVideo(String goodsVideo) {
            this.goodsVideo = goodsVideo;
            return this;
        }

        public GoodsOperationDTOBuilder skuList(List<Map<String, Object>> skuList) {
            this.skuList = skuList;
            return this;
        }

        public GoodsOperationDTOBuilder goodsTemplateFlag(Boolean goodsTemplateFlag) {
            this.goodsTemplateFlag = goodsTemplateFlag;
            return this;
        }

        public GoodsOperationDTOBuilder wholesaleList(List<WholesaleDTO> wholesaleList) {
            this.wholesaleList = wholesaleList;
            return this;
        }

        public GoodsOperationDTOBuilder needingAttention(String needingAttention) {
            this.needingAttention = needingAttention;
            return this;
        }

        public GoodsOperationDTOBuilder annualFeeExclusive(Boolean annualFeeExclusive) {
            this.annualFeeExclusive = annualFeeExclusive;
            return this;
        }

        public GoodsOperationDTOBuilder browsePermissions(String browsePermissions) {
            this.browsePermissions = browsePermissions;
            return this;
        }

        public GoodsOperationDTO build() {
            return new GoodsOperationDTO(this.goodsId, this.price, this.categoryPath, this.storeCategoryPath, this.brandId, this.goodsName, this.intro, this.mobileIntro, this.quantity, this.release, this.recommend, this.goodsParamsDTOList, this.goodsGalleryList, this.templateId, this.sellingPoint, this.salesModel, this.haveSpec, this.goodsUnit, this.info, this.regeneratorSkuFlag, this.goodsType, this.goodsVideo, this.skuList, this.goodsTemplateFlag, this.wholesaleList, this.needingAttention, this.annualFeeExclusive, this.browsePermissions);
        }

        public String toString() {
            return "GoodsOperationDTO.GoodsOperationDTOBuilder(goodsId=" + this.goodsId + ", price=" + this.price + ", categoryPath=" + this.categoryPath + ", storeCategoryPath=" + this.storeCategoryPath + ", brandId=" + this.brandId + ", goodsName=" + this.goodsName + ", intro=" + this.intro + ", mobileIntro=" + this.mobileIntro + ", quantity=" + this.quantity + ", release=" + this.release + ", recommend=" + this.recommend + ", goodsParamsDTOList=" + this.goodsParamsDTOList + ", goodsGalleryList=" + this.goodsGalleryList + ", templateId=" + this.templateId + ", sellingPoint=" + this.sellingPoint + ", salesModel=" + this.salesModel + ", haveSpec=" + this.haveSpec + ", goodsUnit=" + this.goodsUnit + ", info=" + this.info + ", regeneratorSkuFlag=" + this.regeneratorSkuFlag + ", goodsType=" + this.goodsType + ", goodsVideo=" + this.goodsVideo + ", skuList=" + this.skuList + ", goodsTemplateFlag=" + this.goodsTemplateFlag + ", wholesaleList=" + this.wholesaleList + ", needingAttention=" + this.needingAttention + ", annualFeeExclusive=" + this.annualFeeExclusive + ", browsePermissions=" + this.browsePermissions + ")";
        }
    }
}

