/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.logistics;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.logistics.LogisticsPlugin;
import cn.lili.modules.logistics.entity.enums.LogisticsEnum;
import cn.lili.modules.logistics.plugin.kdniao.KdniaoPlugin;
import cn.lili.modules.logistics.plugin.kuaidi100.Kuaidi100Plugin;
import cn.lili.modules.system.client.SettingClient;
import cn.lili.modules.system.entity.dos.Setting;
import cn.lili.modules.system.entity.dto.LogisticsSetting;
import cn.lili.modules.system.entity.enums.SettingEnum;
import org.springframework.stereotype.Component;

@Component
public class LogisticsPluginFactory {
    private final SettingClient settingClient;

    public LogisticsPlugin filePlugin() {
        Setting setting = this.settingClient.get(SettingEnum.LOGISTICS_SETTING.name());
        LogisticsSetting logisticsSetting = (LogisticsSetting)JSONUtil.toBean((String)setting.getSettingValue(), LogisticsSetting.class);
        if (StrUtil.isBlank((CharSequence)logisticsSetting.getType())) {
            throw new ServiceException(ResultCode.LOGISTICS_NOT_SETTING);
        }
        try {
            switch (LogisticsEnum.valueOf(logisticsSetting.getType())) {
                case KDNIAO: {
                    return new KdniaoPlugin(logisticsSetting);
                }
                case KUAIDI100: {
                    return new Kuaidi100Plugin(logisticsSetting);
                }
            }
            throw new ServiceException();
        }
        catch (Exception e) {
            throw new ServiceException();
        }
    }

    public LogisticsPluginFactory(SettingClient settingClient) {
        this.settingClient = settingClient;
    }
}

