/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.logistics.plugin.kdniao;

import cn.hutool.core.text.CharSequenceUtil;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.logistics.LogisticsPlugin;
import cn.lili.modules.logistics.entity.dto.LabelOrderDTO;
import cn.lili.modules.logistics.entity.enums.LogisticsEnum;
import cn.lili.modules.order.order.entity.dos.Order;
import cn.lili.modules.order.order.entity.dos.OrderItem;
import cn.lili.modules.order.order.entity.vo.OrderDetailVO;
import cn.lili.modules.store.entity.dos.StoreLogistics;
import cn.lili.modules.store.entity.dto.StoreDeliverGoodsAddressDTO;
import cn.lili.modules.system.entity.dos.Logistics;
import cn.lili.modules.system.entity.dto.LogisticsSetting;
import cn.lili.modules.system.entity.vo.Traces;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kuaidi100.sdk.response.SubscribeWithMapPushParamResp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class KdniaoPlugin
implements LogisticsPlugin {
    private static final Logger log = LoggerFactory.getLogger(KdniaoPlugin.class);
    @Autowired
    private LogisticsSetting logisticsSetting;
    private static final char[] BASE64_ENCODE_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public KdniaoPlugin(LogisticsSetting logisticsSetting) {
        this.logisticsSetting = logisticsSetting;
    }

    @Override
    public LogisticsEnum pluginName() {
        return LogisticsEnum.KDNIAO;
    }

    @Override
    public Traces pollQuery(Logistics logistics, String expNo, String phone) {
        try {
            String requestData = "{'OrderCode':'','ShipperCode':'" + logistics.getCode() + "','LogisticCode':'" + expNo + "','CustomerName':'" + phone.substring(phone.length() - 4) + "'}";
            String testReqURL = "http://sandboxapi.kdniao.com:8080/kdniaosandbox/gateway/exterfaceInvoke.json";
            String reqURL = "https://api.kdniao.com/Ebusiness/EbusinessOrderHandle.aspx";
            HashMap<String, String> params = new HashMap<String, String>(8);
            params.put("RequestData", this.urlEncoder(requestData, "UTF-8"));
            params.put("EBusinessID", this.logisticsSetting.getKdniaoEbusinessID());
            params.put("RequestType", "1002");
            String dataSign = this.encrypt(requestData, this.logisticsSetting.getKdniaoAppKey(), "UTF-8");
            params.put("DataSign", this.urlEncoder(dataSign, "UTF-8"));
            params.put("DataType", "2");
            String result = this.sendPost(reqURL, params);
            Map map = (Map)JSON.parse((String)result);
            return new Traces(logistics.getName(), expNo, (List)map.get("Traces"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Traces pollMapTrack(Logistics logistics, String expNo, String phone, String from, String to) {
        try {
            String testReqURL = "http://sandboxapi.kdniao.com:8080/kdniaosandbox/gateway/exterfaceInvoke.json";
            String reqURL = "https://api.kdniao.com/Ebusiness/EbusinessOrderHandle.aspx";
            String RequestData = "{'OrderCode': '','CustomerName': '" + phone.substring(phone.length() - 4) + "','ShipperCode': '" + logistics.getCode() + "','LogisticCode': '" + expNo + "','SenderCityName': '" + from + "','ReceiverCityName': '" + to + "','IsReturnCoordinates': 1,'IsReturnRouteMap': 1,}";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("RequestData", this.urlEncoder(RequestData, "UTF-8"));
            params.put("EBusinessID", this.logisticsSetting.getKdniaoEbusinessID());
            params.put("RequestType", "8003");
            String dataSign = this.encrypt(RequestData, this.logisticsSetting.getKdniaoAppKey(), "UTF-8");
            params.put("DataSign", this.urlEncoder(dataSign, "UTF-8"));
            String result = this.sendPost(reqURL, params);
            log.error(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Map<String, Object> labelOrder(LabelOrderDTO labelOrderDTO) {
        try {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            Order order = labelOrderDTO.getOrder();
            List<OrderItem> orderItems = labelOrderDTO.getOrderItems();
            Logistics logistics = labelOrderDTO.getLogistics();
            String[] ConsigneeAddress = order.getConsigneeAddressPath().split(",");
            StoreDeliverGoodsAddressDTO storeDeliverGoodsAddressDTO = labelOrderDTO.getStoreDeliverGoodsAddressDTO();
            String[] consignorAddress = storeDeliverGoodsAddressDTO.getSalesConsignorAddressPath().split(",");
            StoreLogistics storeLogistics = labelOrderDTO.getStoreLogistics();
            String resultDate = "{'OrderCode': '" + order.getSn() + "','ShipperCode': '" + logistics.getCode() + "','CustomerName': '" + storeLogistics.getCustomerName() + "','CustomerPwd': '" + storeLogistics.getCustomerPwd() + "','MonthCode': '" + storeLogistics.getMonthCode() + "','SendSite': '" + storeLogistics.getSendSite() + "','SendStaff': '" + storeLogistics.getSendStaff() + "','PayType': " + storeLogistics.getPayType() + ",'ExpType': " + storeLogistics.getExpType() + ",'Sender': {'Name': '" + storeDeliverGoodsAddressDTO.getSalesConsignorName() + "','Mobile': '" + storeDeliverGoodsAddressDTO.getSalesConsignorMobile() + "','ProvinceName': '" + consignorAddress[0] + "','CityName': '" + consignorAddress[1] + "','ExpAreaName': '" + consignorAddress[2] + "','Address': '" + storeDeliverGoodsAddressDTO.getSalesConsignorDetail() + "'},'Receiver': {'Name': '" + order.getConsigneeName() + "','Mobile': '" + order.getConsigneeMobile() + "','ProvinceName': '" + ConsigneeAddress[0] + "','CityName': '" + ConsigneeAddress[1] + "','ExpAreaName': '" + ConsigneeAddress[2] + "','Address': '" + order.getConsigneeDetail() + "'},'Commodity': [";
            for (OrderItem orderItem : orderItems) {
                resultDate = resultDate + "{'GoodsName': '" + orderItem.getGoodsName() + "','Goodsquantity': '" + orderItem.getNum() + "'},";
            }
            resultDate = resultDate + "],'Quantity': " + orderItems.size() + ",'IsReturnPrintTemplate':1,'Remark': '" + order.getRemark() + "'}";
            HashMap<String, String> params = new HashMap<String, String>();
            String testReqURL = "http://sandboxapi.kdniao.com:8080/kdniaosandbox/gateway/exterfaceInvoke.json";
            String reqURL = "https://api.kdniao.com/api/EOrderService";
            params.put("RequestData", this.urlEncoder(resultDate, "UTF-8"));
            params.put("EBusinessID", this.logisticsSetting.getKdniaoEbusinessID());
            params.put("RequestType", "1007");
            String dataSign = this.encrypt(resultDate, this.logisticsSetting.getKdniaoAppKey(), "UTF-8");
            params.put("DataSign", dataSign);
            params.put("DataType", "2");
            String result = this.sendPost(reqURL, params);
            if (CharSequenceUtil.isEmpty((CharSequence)result) || CharSequenceUtil.isBlank((CharSequence)result)) {
                throw new ServiceException(ResultCode.LOGISTICS_CHECK_SETTING);
            }
            JSONObject obj = JSONObject.parseObject((String)result);
            log.info("\u7535\u5b50\u9762\u5355\u54cd\u5e94\uff1a{}", (Object)result);
            if (!"100".equals(obj.getString("ResultCode"))) {
                resultMap.put("Reason", obj.getString("Reason"));
                return resultMap;
            }
            JSONObject orderJson = JSONObject.parseObject((String)obj.getString("Order"));
            resultMap.put("printTemplate", obj.getString("PrintTemplate"));
            return resultMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String createOrder(OrderDetailVO orderDetailVO) {
        return null;
    }

    @Override
    public Boolean subscribe(Logistics logistics, String expNo, String callbackUrl) {
        return null;
    }

    @Override
    public Traces pushTrack(SubscribeWithMapPushParamResp subscribe) {
        return null;
    }

    private String MD5(String str, String charset) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(str.getBytes(charset));
        byte[] result = md.digest();
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < result.length; ++i) {
            int val = result[i] & 0xFF;
            if (val <= 15) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString().toLowerCase();
    }

    private String base64(String str, String charset) throws UnsupportedEncodingException {
        return KdniaoPlugin.base64Encode(str.getBytes(charset));
    }

    private String urlEncoder(String str, String charset) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, charset);
    }

    private String encrypt(String content, String keyValue, String charset) throws Exception {
        if (keyValue != null) {
            return this.base64(this.MD5(content + keyValue, charset), charset);
        }
        return this.base64(this.MD5(content, charset), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendPost(String url, Map<String, String> params) {
        OutputStreamWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
            if (params != null) {
                StringBuilder param = new StringBuilder();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (param.length() > 0) {
                        param.append("&");
                    }
                    param.append(entry.getKey());
                    param.append("=");
                    param.append(entry.getValue());
                }
                out.write(param.toString());
            }
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            log.error("\u5411\u6307\u5b9a URL \u53d1\u9001POST\u65b9\u6cd5\u7684\u8bf7\u6c42\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result.toString();
    }

    public static String base64Encode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int len = data.length;
        int i = 0;
        while (i < len) {
            int b1 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(BASE64_ENCODE_CHARS[b1 >>> 2]);
                sb.append(BASE64_ENCODE_CHARS[(b1 & 3) << 4]);
                sb.append("==");
                break;
            }
            int b2 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(BASE64_ENCODE_CHARS[b1 >>> 2]);
                sb.append(BASE64_ENCODE_CHARS[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
                sb.append(BASE64_ENCODE_CHARS[(b2 & 0xF) << 2]);
                sb.append("=");
                break;
            }
            int b3 = data[i++] & 0xFF;
            sb.append(BASE64_ENCODE_CHARS[b1 >>> 2]);
            sb.append(BASE64_ENCODE_CHARS[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
            sb.append(BASE64_ENCODE_CHARS[(b2 & 0xF) << 2 | (b3 & 0xC0) >>> 6]);
            sb.append(BASE64_ENCODE_CHARS[b3 & 0x3F]);
        }
        return sb.toString();
    }
}

