/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.order.order.client;

import cn.lili.modules.order.fallback.OrderItemFallback;
import cn.lili.modules.order.order.entity.dos.OrderItem;
import cn.lili.modules.order.order.entity.dto.OrderSearchParams;
import cn.lili.modules.order.order.entity.enums.CommentStatusEnum;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="order-service", contextId="order-item", fallback=OrderItemFallback.class)
public interface OrderItemClient {
    @GetMapping(value={"/feign/orderitem/query/{sn}"})
    public OrderItem getBySn(@PathVariable String var1);

    @GetMapping(value={"/feign/orderitem/query/order-sn-and-sku-id"})
    public OrderItem getByOrderSnAndSkuId(@RequestParam(value="orderSn") String var1, @RequestParam(value="skuId") String var2);

    @GetMapping(value={"/feign/orderitem/query-by-order/{sn}"})
    public List<OrderItem> getByOrderSn(@PathVariable String var1);

    @GetMapping(value={"/feign/orderitem/update/status"})
    public void updateCommentStatus(@RequestParam String var1, @RequestParam CommentStatusEnum var2);

    @PutMapping(value={"/feign/orderitem/updateById"})
    public void updateById(@RequestBody OrderItem var1);

    @PostMapping(value={"/feign/orderitem/save-batch"})
    public void saveBatch(@RequestBody List<OrderItem> var1);

    @PostMapping(value={"/feign/order-item/wait-operation"})
    public List<OrderItem> waitOperationOrderItem(@RequestBody OrderSearchParams var1);

    @PutMapping(value={"/feign/order-item/update/after-sale"})
    public boolean updateAfterSale(@RequestBody List<String> var1);

    @PutMapping(value={"/feign/order-item/update/complain"})
    public boolean updateComplainStatus(@RequestBody List<String> var1);

    @PutMapping(value={"/feign/orderitem/update"})
    public void update(@RequestBody OrderItem var1);
}

