/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.order.order.entity.dos;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import cn.lili.common.utils.BeanUtil;
import cn.lili.common.utils.SnowFlake;
import cn.lili.modules.order.cart.entity.dto.TradeDTO;
import cn.lili.modules.order.cart.entity.vo.CartSkuVO;
import cn.lili.modules.order.cart.entity.vo.CartVO;
import cn.lili.modules.order.order.entity.dto.PriceDetailDTO;
import cn.lili.modules.order.order.entity.enums.CommentStatusEnum;
import cn.lili.modules.order.order.entity.enums.OrderComplaintStatusEnum;
import cn.lili.modules.order.order.entity.enums.OrderItemAfterSaleStatusEnum;
import cn.lili.modules.promotion.entity.vos.PromotionSkuVO;
import cn.lili.mybatis.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.stream.Collectors;

@TableName(value="li_order_item")
@ApiModel(value="\u5b50\u8ba2\u5355")
public class OrderItem
extends BaseEntity {
    private static final long serialVersionUID = 2108971190191410182L;
    @ApiModelProperty(value="\u8ba2\u5355\u7f16\u53f7")
    private String orderSn;
    @ApiModelProperty(value="\u5b50\u8ba2\u5355\u7f16\u53f7")
    private String sn;
    @ApiModelProperty(value="\u5355\u4ef7")
    private Double unitPrice;
    @ApiModelProperty(value="\u5c0f\u8bb0")
    private Double subTotal;
    @ApiModelProperty(value="\u5546\u54c1ID")
    private String goodsId;
    @ApiModelProperty(value="\u8d27\u54c1ID")
    private String skuId;
    @ApiModelProperty(value="\u9500\u552e\u91cf")
    private Integer num;
    @ApiModelProperty(value="\u4ea4\u6613\u7f16\u53f7")
    private String tradeSn;
    @ApiModelProperty(value="\u56fe\u7247")
    private String image;
    @ApiModelProperty(value="\u5546\u54c1\u540d\u79f0")
    private String goodsName;
    @ApiModelProperty(value="\u5206\u7c7bID")
    private String categoryId;
    @ApiModelProperty(value="\u5feb\u7167id")
    private String snapshotId;
    @ApiModelProperty(value="\u89c4\u683cjson")
    private String specs;
    @ApiModelProperty(value="\u4fc3\u9500\u7c7b\u578b")
    private String promotionType;
    @ApiModelProperty(value="\u4fc3\u9500id")
    private String promotionId;
    @ApiModelProperty(value="\u9500\u552e\u91d1\u989d")
    private Double goodsPrice;
    @ApiModelProperty(value="\u5b9e\u9645\u91d1\u989d")
    private Double flowPrice;
    @ApiModelProperty(value="\u8bc4\u8bba\u72b6\u6001:\u672a\u8bc4\u8bba(UNFINISHED),\u5f85\u8ffd\u8bc4(WAIT_CHASE),\u8bc4\u8bba\u5b8c\u6210(FINISHED)\uff0c")
    private String commentStatus;
    @ApiModelProperty(value="\u552e\u540e\u72b6\u6001")
    private String afterSaleStatus;
    @ApiModelProperty(value="\u4ef7\u683c\u8be6\u60c5")
    private String priceDetail;
    @ApiModelProperty(value="\u6295\u8bc9\u72b6\u6001")
    private String complainStatus;
    @ApiModelProperty(value="\u4ea4\u6613\u6295\u8bc9id")
    private String complainId;
    @ApiModelProperty(value="\u9000\u8d27\u5546\u54c1\u6570\u91cf")
    private Integer returnGoodsNumber;

    public OrderItem(CartSkuVO cartSkuVO, CartVO cartVO, TradeDTO tradeDTO) {
        String oldId = this.getId();
        BeanUtil.copyProperties((Object)((Object)cartSkuVO.getGoodsSku()), (Object)((Object)this));
        BeanUtil.copyProperties((Object)cartSkuVO.getPriceDetailDTO(), (Object)((Object)this));
        BeanUtil.copyProperties((Object)cartSkuVO, (Object)((Object)this));
        this.setId(oldId);
        if (cartSkuVO.getPriceDetailDTO().getJoinPromotion() != null && !cartSkuVO.getPriceDetailDTO().getJoinPromotion().isEmpty()) {
            this.setPromotionType(CollUtil.join((Iterable)cartSkuVO.getPriceDetailDTO().getJoinPromotion().stream().map(PromotionSkuVO::getPromotionType).collect(Collectors.toList()), (CharSequence)","));
            this.setPromotionId(CollUtil.join((Iterable)cartSkuVO.getPriceDetailDTO().getJoinPromotion().stream().map(PromotionSkuVO::getActivityId).collect(Collectors.toList()), (CharSequence)","));
        }
        this.setAfterSaleStatus(OrderItemAfterSaleStatusEnum.NEW.name());
        this.setCommentStatus(CommentStatusEnum.NEW.name());
        this.setComplainStatus(OrderComplaintStatusEnum.NEW.name());
        this.setPriceDetailDTO(cartSkuVO.getPriceDetailDTO());
        this.setOrderSn(cartVO.getSn());
        this.setTradeSn(tradeDTO.getSn());
        this.setImage(cartSkuVO.getGoodsSku().getThumbnail());
        this.setGoodsName(cartSkuVO.getGoodsSku().getGoodsName());
        this.setSkuId(cartSkuVO.getGoodsSku().getId());
        this.setCategoryId(cartSkuVO.getGoodsSku().getCategoryPath().substring(cartSkuVO.getGoodsSku().getCategoryPath().lastIndexOf(",") + 1));
        this.setGoodsPrice(cartSkuVO.getGoodsSku().getPrice());
        this.setUnitPrice(cartSkuVO.getPurchasePrice());
        this.setSubTotal(cartSkuVO.getSubTotal());
        this.setSn(SnowFlake.createStr((String)"OI"));
    }

    public PriceDetailDTO getPriceDetailDTO() {
        return (PriceDetailDTO)JSONUtil.toBean((String)this.priceDetail, PriceDetailDTO.class);
    }

    public void setPriceDetailDTO(PriceDetailDTO priceDetail) {
        this.priceDetail = JSONUtil.toJsonStr((Object)priceDetail);
    }

    public static OrderItemBuilder builder() {
        return new OrderItemBuilder();
    }

    public String getOrderSn() {
        return this.orderSn;
    }

    public String getSn() {
        return this.sn;
    }

    public Double getUnitPrice() {
        return this.unitPrice;
    }

    public Double getSubTotal() {
        return this.subTotal;
    }

    public String getGoodsId() {
        return this.goodsId;
    }

    public String getSkuId() {
        return this.skuId;
    }

    public Integer getNum() {
        return this.num;
    }

    public String getTradeSn() {
        return this.tradeSn;
    }

    public String getImage() {
        return this.image;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getSpecs() {
        return this.specs;
    }

    public String getPromotionType() {
        return this.promotionType;
    }

    public String getPromotionId() {
        return this.promotionId;
    }

    public Double getGoodsPrice() {
        return this.goodsPrice;
    }

    public Double getFlowPrice() {
        return this.flowPrice;
    }

    public String getCommentStatus() {
        return this.commentStatus;
    }

    public String getAfterSaleStatus() {
        return this.afterSaleStatus;
    }

    public String getPriceDetail() {
        return this.priceDetail;
    }

    public String getComplainStatus() {
        return this.complainStatus;
    }

    public String getComplainId() {
        return this.complainId;
    }

    public Integer getReturnGoodsNumber() {
        return this.returnGoodsNumber;
    }

    public void setOrderSn(String orderSn) {
        this.orderSn = orderSn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setUnitPrice(Double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public void setSubTotal(Double subTotal) {
        this.subTotal = subTotal;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public void setTradeSn(String tradeSn) {
        this.tradeSn = tradeSn;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setSpecs(String specs) {
        this.specs = specs;
    }

    public void setPromotionType(String promotionType) {
        this.promotionType = promotionType;
    }

    public void setPromotionId(String promotionId) {
        this.promotionId = promotionId;
    }

    public void setGoodsPrice(Double goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public void setFlowPrice(Double flowPrice) {
        this.flowPrice = flowPrice;
    }

    public void setCommentStatus(String commentStatus) {
        this.commentStatus = commentStatus;
    }

    public void setAfterSaleStatus(String afterSaleStatus) {
        this.afterSaleStatus = afterSaleStatus;
    }

    public void setPriceDetail(String priceDetail) {
        this.priceDetail = priceDetail;
    }

    public void setComplainStatus(String complainStatus) {
        this.complainStatus = complainStatus;
    }

    public void setComplainId(String complainId) {
        this.complainId = complainId;
    }

    public void setReturnGoodsNumber(Integer returnGoodsNumber) {
        this.returnGoodsNumber = returnGoodsNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderItem)) {
            return false;
        }
        OrderItem other = (OrderItem)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Double this$unitPrice = this.getUnitPrice();
        Double other$unitPrice = other.getUnitPrice();
        if (this$unitPrice == null ? other$unitPrice != null : !((Object)this$unitPrice).equals(other$unitPrice)) {
            return false;
        }
        Double this$subTotal = this.getSubTotal();
        Double other$subTotal = other.getSubTotal();
        if (this$subTotal == null ? other$subTotal != null : !((Object)this$subTotal).equals(other$subTotal)) {
            return false;
        }
        Integer this$num = this.getNum();
        Integer other$num = other.getNum();
        if (this$num == null ? other$num != null : !((Object)this$num).equals(other$num)) {
            return false;
        }
        Double this$goodsPrice = this.getGoodsPrice();
        Double other$goodsPrice = other.getGoodsPrice();
        if (this$goodsPrice == null ? other$goodsPrice != null : !((Object)this$goodsPrice).equals(other$goodsPrice)) {
            return false;
        }
        Double this$flowPrice = this.getFlowPrice();
        Double other$flowPrice = other.getFlowPrice();
        if (this$flowPrice == null ? other$flowPrice != null : !((Object)this$flowPrice).equals(other$flowPrice)) {
            return false;
        }
        Integer this$returnGoodsNumber = this.getReturnGoodsNumber();
        Integer other$returnGoodsNumber = other.getReturnGoodsNumber();
        if (this$returnGoodsNumber == null ? other$returnGoodsNumber != null : !((Object)this$returnGoodsNumber).equals(other$returnGoodsNumber)) {
            return false;
        }
        String this$orderSn = this.getOrderSn();
        String other$orderSn = other.getOrderSn();
        if (this$orderSn == null ? other$orderSn != null : !this$orderSn.equals(other$orderSn)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        String this$goodsId = this.getGoodsId();
        String other$goodsId = other.getGoodsId();
        if (this$goodsId == null ? other$goodsId != null : !this$goodsId.equals(other$goodsId)) {
            return false;
        }
        String this$skuId = this.getSkuId();
        String other$skuId = other.getSkuId();
        if (this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId)) {
            return false;
        }
        String this$tradeSn = this.getTradeSn();
        String other$tradeSn = other.getTradeSn();
        if (this$tradeSn == null ? other$tradeSn != null : !this$tradeSn.equals(other$tradeSn)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$goodsName = this.getGoodsName();
        String other$goodsName = other.getGoodsName();
        if (this$goodsName == null ? other$goodsName != null : !this$goodsName.equals(other$goodsName)) {
            return false;
        }
        String this$categoryId = this.getCategoryId();
        String other$categoryId = other.getCategoryId();
        if (this$categoryId == null ? other$categoryId != null : !this$categoryId.equals(other$categoryId)) {
            return false;
        }
        String this$snapshotId = this.getSnapshotId();
        String other$snapshotId = other.getSnapshotId();
        if (this$snapshotId == null ? other$snapshotId != null : !this$snapshotId.equals(other$snapshotId)) {
            return false;
        }
        String this$specs = this.getSpecs();
        String other$specs = other.getSpecs();
        if (this$specs == null ? other$specs != null : !this$specs.equals(other$specs)) {
            return false;
        }
        String this$promotionType = this.getPromotionType();
        String other$promotionType = other.getPromotionType();
        if (this$promotionType == null ? other$promotionType != null : !this$promotionType.equals(other$promotionType)) {
            return false;
        }
        String this$promotionId = this.getPromotionId();
        String other$promotionId = other.getPromotionId();
        if (this$promotionId == null ? other$promotionId != null : !this$promotionId.equals(other$promotionId)) {
            return false;
        }
        String this$commentStatus = this.getCommentStatus();
        String other$commentStatus = other.getCommentStatus();
        if (this$commentStatus == null ? other$commentStatus != null : !this$commentStatus.equals(other$commentStatus)) {
            return false;
        }
        String this$afterSaleStatus = this.getAfterSaleStatus();
        String other$afterSaleStatus = other.getAfterSaleStatus();
        if (this$afterSaleStatus == null ? other$afterSaleStatus != null : !this$afterSaleStatus.equals(other$afterSaleStatus)) {
            return false;
        }
        String this$priceDetail = this.getPriceDetail();
        String other$priceDetail = other.getPriceDetail();
        if (this$priceDetail == null ? other$priceDetail != null : !this$priceDetail.equals(other$priceDetail)) {
            return false;
        }
        String this$complainStatus = this.getComplainStatus();
        String other$complainStatus = other.getComplainStatus();
        if (this$complainStatus == null ? other$complainStatus != null : !this$complainStatus.equals(other$complainStatus)) {
            return false;
        }
        String this$complainId = this.getComplainId();
        String other$complainId = other.getComplainId();
        return !(this$complainId == null ? other$complainId != null : !this$complainId.equals(other$complainId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $unitPrice = this.getUnitPrice();
        result = result * 59 + ($unitPrice == null ? 43 : ((Object)$unitPrice).hashCode());
        Double $subTotal = this.getSubTotal();
        result = result * 59 + ($subTotal == null ? 43 : ((Object)$subTotal).hashCode());
        Integer $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : ((Object)$num).hashCode());
        Double $goodsPrice = this.getGoodsPrice();
        result = result * 59 + ($goodsPrice == null ? 43 : ((Object)$goodsPrice).hashCode());
        Double $flowPrice = this.getFlowPrice();
        result = result * 59 + ($flowPrice == null ? 43 : ((Object)$flowPrice).hashCode());
        Integer $returnGoodsNumber = this.getReturnGoodsNumber();
        result = result * 59 + ($returnGoodsNumber == null ? 43 : ((Object)$returnGoodsNumber).hashCode());
        String $orderSn = this.getOrderSn();
        result = result * 59 + ($orderSn == null ? 43 : $orderSn.hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        String $goodsId = this.getGoodsId();
        result = result * 59 + ($goodsId == null ? 43 : $goodsId.hashCode());
        String $skuId = this.getSkuId();
        result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
        String $tradeSn = this.getTradeSn();
        result = result * 59 + ($tradeSn == null ? 43 : $tradeSn.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $goodsName = this.getGoodsName();
        result = result * 59 + ($goodsName == null ? 43 : $goodsName.hashCode());
        String $categoryId = this.getCategoryId();
        result = result * 59 + ($categoryId == null ? 43 : $categoryId.hashCode());
        String $snapshotId = this.getSnapshotId();
        result = result * 59 + ($snapshotId == null ? 43 : $snapshotId.hashCode());
        String $specs = this.getSpecs();
        result = result * 59 + ($specs == null ? 43 : $specs.hashCode());
        String $promotionType = this.getPromotionType();
        result = result * 59 + ($promotionType == null ? 43 : $promotionType.hashCode());
        String $promotionId = this.getPromotionId();
        result = result * 59 + ($promotionId == null ? 43 : $promotionId.hashCode());
        String $commentStatus = this.getCommentStatus();
        result = result * 59 + ($commentStatus == null ? 43 : $commentStatus.hashCode());
        String $afterSaleStatus = this.getAfterSaleStatus();
        result = result * 59 + ($afterSaleStatus == null ? 43 : $afterSaleStatus.hashCode());
        String $priceDetail = this.getPriceDetail();
        result = result * 59 + ($priceDetail == null ? 43 : $priceDetail.hashCode());
        String $complainStatus = this.getComplainStatus();
        result = result * 59 + ($complainStatus == null ? 43 : $complainStatus.hashCode());
        String $complainId = this.getComplainId();
        result = result * 59 + ($complainId == null ? 43 : $complainId.hashCode());
        return result;
    }

    public String toString() {
        return "OrderItem(orderSn=" + this.getOrderSn() + ", sn=" + this.getSn() + ", unitPrice=" + this.getUnitPrice() + ", subTotal=" + this.getSubTotal() + ", goodsId=" + this.getGoodsId() + ", skuId=" + this.getSkuId() + ", num=" + this.getNum() + ", tradeSn=" + this.getTradeSn() + ", image=" + this.getImage() + ", goodsName=" + this.getGoodsName() + ", categoryId=" + this.getCategoryId() + ", snapshotId=" + this.getSnapshotId() + ", specs=" + this.getSpecs() + ", promotionType=" + this.getPromotionType() + ", promotionId=" + this.getPromotionId() + ", goodsPrice=" + this.getGoodsPrice() + ", flowPrice=" + this.getFlowPrice() + ", commentStatus=" + this.getCommentStatus() + ", afterSaleStatus=" + this.getAfterSaleStatus() + ", priceDetail=" + this.getPriceDetail() + ", complainStatus=" + this.getComplainStatus() + ", complainId=" + this.getComplainId() + ", returnGoodsNumber=" + this.getReturnGoodsNumber() + ")";
    }

    public OrderItem() {
    }

    public OrderItem(String orderSn, String sn, Double unitPrice, Double subTotal, String goodsId, String skuId, Integer num, String tradeSn, String image, String goodsName, String categoryId, String snapshotId, String specs, String promotionType, String promotionId, Double goodsPrice, Double flowPrice, String commentStatus, String afterSaleStatus, String priceDetail, String complainStatus, String complainId, Integer returnGoodsNumber) {
        this.orderSn = orderSn;
        this.sn = sn;
        this.unitPrice = unitPrice;
        this.subTotal = subTotal;
        this.goodsId = goodsId;
        this.skuId = skuId;
        this.num = num;
        this.tradeSn = tradeSn;
        this.image = image;
        this.goodsName = goodsName;
        this.categoryId = categoryId;
        this.snapshotId = snapshotId;
        this.specs = specs;
        this.promotionType = promotionType;
        this.promotionId = promotionId;
        this.goodsPrice = goodsPrice;
        this.flowPrice = flowPrice;
        this.commentStatus = commentStatus;
        this.afterSaleStatus = afterSaleStatus;
        this.priceDetail = priceDetail;
        this.complainStatus = complainStatus;
        this.complainId = complainId;
        this.returnGoodsNumber = returnGoodsNumber;
    }

    public static class OrderItemBuilder {
        private String orderSn;
        private String sn;
        private Double unitPrice;
        private Double subTotal;
        private String goodsId;
        private String skuId;
        private Integer num;
        private String tradeSn;
        private String image;
        private String goodsName;
        private String categoryId;
        private String snapshotId;
        private String specs;
        private String promotionType;
        private String promotionId;
        private Double goodsPrice;
        private Double flowPrice;
        private String commentStatus;
        private String afterSaleStatus;
        private String priceDetail;
        private String complainStatus;
        private String complainId;
        private Integer returnGoodsNumber;

        OrderItemBuilder() {
        }

        public OrderItemBuilder orderSn(String orderSn) {
            this.orderSn = orderSn;
            return this;
        }

        public OrderItemBuilder sn(String sn) {
            this.sn = sn;
            return this;
        }

        public OrderItemBuilder unitPrice(Double unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public OrderItemBuilder subTotal(Double subTotal) {
            this.subTotal = subTotal;
            return this;
        }

        public OrderItemBuilder goodsId(String goodsId) {
            this.goodsId = goodsId;
            return this;
        }

        public OrderItemBuilder skuId(String skuId) {
            this.skuId = skuId;
            return this;
        }

        public OrderItemBuilder num(Integer num) {
            this.num = num;
            return this;
        }

        public OrderItemBuilder tradeSn(String tradeSn) {
            this.tradeSn = tradeSn;
            return this;
        }

        public OrderItemBuilder image(String image) {
            this.image = image;
            return this;
        }

        public OrderItemBuilder goodsName(String goodsName) {
            this.goodsName = goodsName;
            return this;
        }

        public OrderItemBuilder categoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public OrderItemBuilder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public OrderItemBuilder specs(String specs) {
            this.specs = specs;
            return this;
        }

        public OrderItemBuilder promotionType(String promotionType) {
            this.promotionType = promotionType;
            return this;
        }

        public OrderItemBuilder promotionId(String promotionId) {
            this.promotionId = promotionId;
            return this;
        }

        public OrderItemBuilder goodsPrice(Double goodsPrice) {
            this.goodsPrice = goodsPrice;
            return this;
        }

        public OrderItemBuilder flowPrice(Double flowPrice) {
            this.flowPrice = flowPrice;
            return this;
        }

        public OrderItemBuilder commentStatus(String commentStatus) {
            this.commentStatus = commentStatus;
            return this;
        }

        public OrderItemBuilder afterSaleStatus(String afterSaleStatus) {
            this.afterSaleStatus = afterSaleStatus;
            return this;
        }

        public OrderItemBuilder priceDetail(String priceDetail) {
            this.priceDetail = priceDetail;
            return this;
        }

        public OrderItemBuilder complainStatus(String complainStatus) {
            this.complainStatus = complainStatus;
            return this;
        }

        public OrderItemBuilder complainId(String complainId) {
            this.complainId = complainId;
            return this;
        }

        public OrderItemBuilder returnGoodsNumber(Integer returnGoodsNumber) {
            this.returnGoodsNumber = returnGoodsNumber;
            return this;
        }

        public OrderItem build() {
            return new OrderItem(this.orderSn, this.sn, this.unitPrice, this.subTotal, this.goodsId, this.skuId, this.num, this.tradeSn, this.image, this.goodsName, this.categoryId, this.snapshotId, this.specs, this.promotionType, this.promotionId, this.goodsPrice, this.flowPrice, this.commentStatus, this.afterSaleStatus, this.priceDetail, this.complainStatus, this.complainId, this.returnGoodsNumber);
        }

        public String toString() {
            return "OrderItem.OrderItemBuilder(orderSn=" + this.orderSn + ", sn=" + this.sn + ", unitPrice=" + this.unitPrice + ", subTotal=" + this.subTotal + ", goodsId=" + this.goodsId + ", skuId=" + this.skuId + ", num=" + this.num + ", tradeSn=" + this.tradeSn + ", image=" + this.image + ", goodsName=" + this.goodsName + ", categoryId=" + this.categoryId + ", snapshotId=" + this.snapshotId + ", specs=" + this.specs + ", promotionType=" + this.promotionType + ", promotionId=" + this.promotionId + ", goodsPrice=" + this.goodsPrice + ", flowPrice=" + this.flowPrice + ", commentStatus=" + this.commentStatus + ", afterSaleStatus=" + this.afterSaleStatus + ", priceDetail=" + this.priceDetail + ", complainStatus=" + this.complainStatus + ", complainId=" + this.complainId + ", returnGoodsNumber=" + this.returnGoodsNumber + ")";
        }
    }
}

