/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.order.order.entity.vo;

import cn.lili.modules.order.cart.entity.enums.DeliveryMethodEnum;
import cn.lili.modules.order.order.entity.dos.Order;
import cn.lili.modules.order.order.entity.dos.OrderItem;
import cn.lili.modules.order.order.entity.dos.Receipt;
import cn.lili.modules.order.order.entity.enums.DeliverStatusEnum;
import cn.lili.modules.order.order.entity.enums.OrderStatusEnum;
import cn.lili.modules.order.order.entity.enums.PayStatusEnum;
import cn.lili.modules.order.order.entity.vo.AllowOperation;
import cn.lili.modules.order.trade.entity.dos.OrderLog;
import cn.lili.modules.payment.entity.enums.PaymentMethodEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;

public class OrderDetailVO
implements Serializable {
    private static final long serialVersionUID = -6293102172184734928L;
    private Order order;
    private List<OrderItem> orderItems;
    private String orderStatusValue;
    private String payStatusValue;
    private String deliverStatusValue;
    private String deliveryMethodValue;
    private String paymentMethodValue;
    private Receipt receipt;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value="\u53d6\u6d88\u8ba2\u5355\u65f6\u95f4")
    private Date cancelOrderTime;
    private List<OrderLog> orderLogs;
    @ApiModelProperty(value="\u4ef7\u683c\u8be6\u60c5")
    private String priceDetail;

    public OrderDetailVO(Order order, List<OrderItem> orderItems, List<OrderLog> orderLogs, Receipt receipt) {
        this.order = order;
        this.orderItems = orderItems;
        this.orderLogs = orderLogs;
        this.receipt = receipt;
    }

    public AllowOperation getAllowOperationVO() {
        return new AllowOperation(this.order);
    }

    public String getOrderStatusValue() {
        try {
            return OrderStatusEnum.valueOf(this.order.getOrderStatus()).description();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getPayStatusValue() {
        try {
            return PayStatusEnum.valueOf(this.order.getPayStatus()).description();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getDeliverStatusValue() {
        try {
            return DeliverStatusEnum.valueOf(this.order.getDeliverStatus()).getDescription();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getDeliveryMethodValue() {
        try {
            return DeliveryMethodEnum.valueOf(this.order.getDeliveryMethod()).getDescription();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getPaymentMethodValue() {
        try {
            return PaymentMethodEnum.valueOf(this.order.getPaymentMethod()).paymentName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public Order getOrder() {
        return this.order;
    }

    public List<OrderItem> getOrderItems() {
        return this.orderItems;
    }

    public Receipt getReceipt() {
        return this.receipt;
    }

    public Date getCancelOrderTime() {
        return this.cancelOrderTime;
    }

    public List<OrderLog> getOrderLogs() {
        return this.orderLogs;
    }

    public String getPriceDetail() {
        return this.priceDetail;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setOrderItems(List<OrderItem> orderItems) {
        this.orderItems = orderItems;
    }

    public void setOrderStatusValue(String orderStatusValue) {
        this.orderStatusValue = orderStatusValue;
    }

    public void setPayStatusValue(String payStatusValue) {
        this.payStatusValue = payStatusValue;
    }

    public void setDeliverStatusValue(String deliverStatusValue) {
        this.deliverStatusValue = deliverStatusValue;
    }

    public void setDeliveryMethodValue(String deliveryMethodValue) {
        this.deliveryMethodValue = deliveryMethodValue;
    }

    public void setPaymentMethodValue(String paymentMethodValue) {
        this.paymentMethodValue = paymentMethodValue;
    }

    public void setReceipt(Receipt receipt) {
        this.receipt = receipt;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setCancelOrderTime(Date cancelOrderTime) {
        this.cancelOrderTime = cancelOrderTime;
    }

    public void setOrderLogs(List<OrderLog> orderLogs) {
        this.orderLogs = orderLogs;
    }

    public void setPriceDetail(String priceDetail) {
        this.priceDetail = priceDetail;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderDetailVO)) {
            return false;
        }
        OrderDetailVO other = (OrderDetailVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Order this$order = this.getOrder();
        Order other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)((Object)this$order)).equals((Object)other$order)) {
            return false;
        }
        List<OrderItem> this$orderItems = this.getOrderItems();
        List<OrderItem> other$orderItems = other.getOrderItems();
        if (this$orderItems == null ? other$orderItems != null : !((Object)this$orderItems).equals(other$orderItems)) {
            return false;
        }
        String this$orderStatusValue = this.getOrderStatusValue();
        String other$orderStatusValue = other.getOrderStatusValue();
        if (this$orderStatusValue == null ? other$orderStatusValue != null : !this$orderStatusValue.equals(other$orderStatusValue)) {
            return false;
        }
        String this$payStatusValue = this.getPayStatusValue();
        String other$payStatusValue = other.getPayStatusValue();
        if (this$payStatusValue == null ? other$payStatusValue != null : !this$payStatusValue.equals(other$payStatusValue)) {
            return false;
        }
        String this$deliverStatusValue = this.getDeliverStatusValue();
        String other$deliverStatusValue = other.getDeliverStatusValue();
        if (this$deliverStatusValue == null ? other$deliverStatusValue != null : !this$deliverStatusValue.equals(other$deliverStatusValue)) {
            return false;
        }
        String this$deliveryMethodValue = this.getDeliveryMethodValue();
        String other$deliveryMethodValue = other.getDeliveryMethodValue();
        if (this$deliveryMethodValue == null ? other$deliveryMethodValue != null : !this$deliveryMethodValue.equals(other$deliveryMethodValue)) {
            return false;
        }
        String this$paymentMethodValue = this.getPaymentMethodValue();
        String other$paymentMethodValue = other.getPaymentMethodValue();
        if (this$paymentMethodValue == null ? other$paymentMethodValue != null : !this$paymentMethodValue.equals(other$paymentMethodValue)) {
            return false;
        }
        Receipt this$receipt = this.getReceipt();
        Receipt other$receipt = other.getReceipt();
        if (this$receipt == null ? other$receipt != null : !((Object)((Object)this$receipt)).equals((Object)other$receipt)) {
            return false;
        }
        Date this$cancelOrderTime = this.getCancelOrderTime();
        Date other$cancelOrderTime = other.getCancelOrderTime();
        if (this$cancelOrderTime == null ? other$cancelOrderTime != null : !((Object)this$cancelOrderTime).equals(other$cancelOrderTime)) {
            return false;
        }
        List<OrderLog> this$orderLogs = this.getOrderLogs();
        List<OrderLog> other$orderLogs = other.getOrderLogs();
        if (this$orderLogs == null ? other$orderLogs != null : !((Object)this$orderLogs).equals(other$orderLogs)) {
            return false;
        }
        String this$priceDetail = this.getPriceDetail();
        String other$priceDetail = other.getPriceDetail();
        return !(this$priceDetail == null ? other$priceDetail != null : !this$priceDetail.equals(other$priceDetail));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderDetailVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Order $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)((Object)$order)).hashCode());
        List<OrderItem> $orderItems = this.getOrderItems();
        result = result * 59 + ($orderItems == null ? 43 : ((Object)$orderItems).hashCode());
        String $orderStatusValue = this.getOrderStatusValue();
        result = result * 59 + ($orderStatusValue == null ? 43 : $orderStatusValue.hashCode());
        String $payStatusValue = this.getPayStatusValue();
        result = result * 59 + ($payStatusValue == null ? 43 : $payStatusValue.hashCode());
        String $deliverStatusValue = this.getDeliverStatusValue();
        result = result * 59 + ($deliverStatusValue == null ? 43 : $deliverStatusValue.hashCode());
        String $deliveryMethodValue = this.getDeliveryMethodValue();
        result = result * 59 + ($deliveryMethodValue == null ? 43 : $deliveryMethodValue.hashCode());
        String $paymentMethodValue = this.getPaymentMethodValue();
        result = result * 59 + ($paymentMethodValue == null ? 43 : $paymentMethodValue.hashCode());
        Receipt $receipt = this.getReceipt();
        result = result * 59 + ($receipt == null ? 43 : ((Object)((Object)$receipt)).hashCode());
        Date $cancelOrderTime = this.getCancelOrderTime();
        result = result * 59 + ($cancelOrderTime == null ? 43 : ((Object)$cancelOrderTime).hashCode());
        List<OrderLog> $orderLogs = this.getOrderLogs();
        result = result * 59 + ($orderLogs == null ? 43 : ((Object)$orderLogs).hashCode());
        String $priceDetail = this.getPriceDetail();
        result = result * 59 + ($priceDetail == null ? 43 : $priceDetail.hashCode());
        return result;
    }

    public String toString() {
        return "OrderDetailVO(order=" + (Object)((Object)this.getOrder()) + ", orderItems=" + this.getOrderItems() + ", orderStatusValue=" + this.getOrderStatusValue() + ", payStatusValue=" + this.getPayStatusValue() + ", deliverStatusValue=" + this.getDeliverStatusValue() + ", deliveryMethodValue=" + this.getDeliveryMethodValue() + ", paymentMethodValue=" + this.getPaymentMethodValue() + ", receipt=" + (Object)((Object)this.getReceipt()) + ", cancelOrderTime=" + this.getCancelOrderTime() + ", orderLogs=" + this.getOrderLogs() + ", priceDetail=" + this.getPriceDetail() + ")";
    }

    public OrderDetailVO() {
    }
}

