/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.payment.entity.dos;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.json.JSONUtil;
import cn.lili.common.utils.BeanUtil;
import cn.lili.common.utils.CurrencyUtil;
import cn.lili.common.utils.SnowFlake;
import cn.lili.modules.order.order.entity.dos.Order;
import cn.lili.modules.order.order.entity.dos.OrderItem;
import cn.lili.modules.order.order.entity.dto.PriceDetailDTO;
import cn.lili.modules.order.order.entity.enums.FlowTypeEnum;
import cn.lili.modules.order.order.entity.enums.OrderPromotionTypeEnum;
import cn.lili.mybatis.BaseIdEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.format.annotation.DateTimeFormat;

@TableName(value="li_store_flow")
@ApiModel(value="\u5546\u5bb6\u8ba2\u5355\u6d41\u6c34")
public class StoreFlow
extends BaseIdEntity {
    private static final long serialVersionUID = -5998757398902747939L;
    @ApiModelProperty(value="\u6d41\u6c34\u7f16\u53f7")
    private String sn;
    @ApiModelProperty(value="\u8ba2\u5355sn")
    private String orderSn;
    @ApiModelProperty(value="\u5b50\u8ba2\u5355sn")
    private String orderItemSn;
    @ApiModelProperty(value="\u552e\u540eSN")
    private String refundSn;
    @ApiModelProperty(value="\u5e97\u94faid")
    private String storeId;
    @ApiModelProperty(value="\u5e97\u94fa\u540d\u79f0 ")
    private String storeName;
    @ApiModelProperty(value="\u4f1a\u5458id")
    private String memberId;
    @ApiModelProperty(value="\u4f1a\u5458\u540d\u79f0")
    private String memberName;
    @ApiModelProperty(value="\u5546\u54c1ID")
    private String goodsId;
    @ApiModelProperty(value="\u5546\u54c1\u540d\u79f0")
    private String goodsName;
    @ApiModelProperty(value="\u8d27\u54c1ID")
    private String skuId;
    @ApiModelProperty(value="\u56fe\u7247")
    private String image;
    @ApiModelProperty(value="\u5206\u7c7bID")
    private String categoryId;
    @ApiModelProperty(value="\u89c4\u683cjson")
    private String specs;
    @ApiModelProperty(value="\u6d41\u6c34\u7c7b\u578b\uff1aPAY/REFUND \u652f\u4ed8/\u9000\u6b3e", allowableValues="PAY,REFUND")
    private String flowType;
    @ApiModelProperty(value="\u8ba2\u5355\u4fc3\u9500\u7c7b\u578b")
    private String orderPromotionType;
    @ApiModelProperty(value="\u79ef\u5206\u6d3b\u52a8\u5546\u54c1\u7ed3\u7b97\u4ef7\u683c")
    private Double pointSettlementPrice;
    @ApiModelProperty(value="\u780d\u4ef7\u6d3b\u52a8\u5546\u54c1\u7ed3\u7b97\u4ef7\u683c")
    private Double kanjiaSettlementPrice;
    @ApiModelProperty(value="\u5e73\u53f0\u4f18\u60e0\u5238 \u4f7f\u7528\u91d1\u989d")
    private Double siteCouponPrice;
    @ApiModelProperty(value="\u7ad9\u70b9\u4f18\u60e0\u5238\u8865\u8d34\u6bd4\u4f8b")
    private Double siteCouponPoint;
    @ApiModelProperty(value="\u7ad9\u70b9\u4f18\u60e0\u5238\u8865\u8d34\u91d1\u989d")
    private Double siteCouponCommission;
    @ApiModelProperty(value="\u5355\u54c1\u5206\u9500\u8fd4\u73b0\u652f\u51fa")
    private Double distributionRebate;
    @ApiModelProperty(value="\u5e73\u53f0\u6536\u53d6\u4ea4\u6613\u4f63\u91d1")
    private Double commissionPrice;
    @ApiModelProperty(value="\u6d41\u6c34\u91d1\u989d")
    private Double finalPrice;
    @ApiModelProperty(value="\u6700\u7ec8\u7ed3\u7b97\u91d1\u989d")
    private Double billPrice;
    @ApiModelProperty(value="\u7b2c\u4e09\u65b9\u4ea4\u6613\u6d41\u6c34\u53f7")
    private String transactionId;
    @ApiModelProperty(value="\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0")
    private String paymentName;
    @ApiModelProperty(value="\u9500\u552e\u91cf")
    private Integer num;
    @CreatedDate
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField(fill=FieldFill.INSERT)
    @ApiModelProperty(value="\u521b\u5efa\u65f6\u95f4", hidden=true)
    private Date createTime;
    @ApiModelProperty(value="\u5b9e\u9645\u5206\u8d26\u91d1\u989dDTO", hidden=true)
    private String profitSharing;
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField(fill=FieldFill.INSERT)
    @ApiModelProperty(value="\u7ed3\u7b97\u65f6\u95f4")
    private Date billTime;
    @ApiModelProperty(value="\u662f\u5426\u5168\u90e8\u9000\u6b3e\uff0ctrue\u4e3a\u5168\u90e8\u9000\u6b3e")
    private Boolean fullRefund;

    public StoreFlow(Order order, OrderItem item, FlowTypeEnum flowTypeEnum) {
        String promotionType = order.getOrderPromotionType();
        BeanUtil.copyProperties((Object)((Object)item), (Object)((Object)this));
        this.setCreateTime(null);
        this.setId(SnowFlake.getIdStr());
        this.setFlowType(flowTypeEnum.name());
        this.setSn(SnowFlake.createStr((String)"SF"));
        this.setOrderSn(item.getOrderSn());
        this.setOrderItemSn(item.getSn());
        this.setStoreId(order.getStoreId());
        this.setStoreName(order.getStoreName());
        this.setMemberId(order.getMemberId());
        this.setMemberName(order.getMemberName());
        this.setGoodsName(item.getGoodsName());
        this.setOrderPromotionType(item.getPromotionType());
        PriceDetailDTO priceDetailDTO = (PriceDetailDTO)JSONUtil.toBean((String)item.getPriceDetail(), PriceDetailDTO.class);
        this.setSiteCouponPoint(CurrencyUtil.sub((double[])new double[]{100.0, priceDetailDTO.getSiteCouponPoint()}));
        this.setSiteCouponPrice(priceDetailDTO.getSiteCouponPrice());
        this.setSiteCouponCommission(CurrencyUtil.mul((double)this.getSiteCouponPrice(), (double)CurrencyUtil.div((double)this.getSiteCouponPoint(), (double)100.0)));
        this.setFinalPrice(item.getPriceDetailDTO().getFlowPrice());
        this.setCommissionPrice(item.getPriceDetailDTO().getPlatFormCommission());
        this.setDistributionRebate(item.getPriceDetailDTO().getDistributionCommission());
        this.setBillPrice(item.getPriceDetailDTO().getBillPrice());
        if (CharSequenceUtil.isNotEmpty((CharSequence)promotionType)) {
            if (promotionType.equals(OrderPromotionTypeEnum.KANJIA.name())) {
                this.setKanjiaSettlementPrice(item.getPriceDetailDTO().getSettlementPrice());
            } else if (promotionType.equals(OrderPromotionTypeEnum.POINTS.name())) {
                this.setPointSettlementPrice(item.getPriceDetailDTO().getSettlementPrice());
            }
        }
        this.setPaymentName(order.getPaymentMethod());
        this.setTransactionId(order.getReceivableNo());
        if (flowTypeEnum.equals((Object)FlowTypeEnum.PAY)) {
            this.billTime = DateUtil.offsetDay((Date)new Date(), (int)35);
            this.fullRefund = false;
        }
    }

    public String getSn() {
        return this.sn;
    }

    public String getOrderSn() {
        return this.orderSn;
    }

    public String getOrderItemSn() {
        return this.orderItemSn;
    }

    public String getRefundSn() {
        return this.refundSn;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getGoodsId() {
        return this.goodsId;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public String getSkuId() {
        return this.skuId;
    }

    public String getImage() {
        return this.image;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getSpecs() {
        return this.specs;
    }

    public String getFlowType() {
        return this.flowType;
    }

    public String getOrderPromotionType() {
        return this.orderPromotionType;
    }

    public Double getPointSettlementPrice() {
        return this.pointSettlementPrice;
    }

    public Double getKanjiaSettlementPrice() {
        return this.kanjiaSettlementPrice;
    }

    public Double getSiteCouponPrice() {
        return this.siteCouponPrice;
    }

    public Double getSiteCouponPoint() {
        return this.siteCouponPoint;
    }

    public Double getSiteCouponCommission() {
        return this.siteCouponCommission;
    }

    public Double getDistributionRebate() {
        return this.distributionRebate;
    }

    public Double getCommissionPrice() {
        return this.commissionPrice;
    }

    public Double getFinalPrice() {
        return this.finalPrice;
    }

    public Double getBillPrice() {
        return this.billPrice;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getPaymentName() {
        return this.paymentName;
    }

    public Integer getNum() {
        return this.num;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getProfitSharing() {
        return this.profitSharing;
    }

    public Date getBillTime() {
        return this.billTime;
    }

    public Boolean getFullRefund() {
        return this.fullRefund;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setOrderSn(String orderSn) {
        this.orderSn = orderSn;
    }

    public void setOrderItemSn(String orderItemSn) {
        this.orderItemSn = orderItemSn;
    }

    public void setRefundSn(String refundSn) {
        this.refundSn = refundSn;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public void setSpecs(String specs) {
        this.specs = specs;
    }

    public void setFlowType(String flowType) {
        this.flowType = flowType;
    }

    public void setOrderPromotionType(String orderPromotionType) {
        this.orderPromotionType = orderPromotionType;
    }

    public void setPointSettlementPrice(Double pointSettlementPrice) {
        this.pointSettlementPrice = pointSettlementPrice;
    }

    public void setKanjiaSettlementPrice(Double kanjiaSettlementPrice) {
        this.kanjiaSettlementPrice = kanjiaSettlementPrice;
    }

    public void setSiteCouponPrice(Double siteCouponPrice) {
        this.siteCouponPrice = siteCouponPrice;
    }

    public void setSiteCouponPoint(Double siteCouponPoint) {
        this.siteCouponPoint = siteCouponPoint;
    }

    public void setSiteCouponCommission(Double siteCouponCommission) {
        this.siteCouponCommission = siteCouponCommission;
    }

    public void setDistributionRebate(Double distributionRebate) {
        this.distributionRebate = distributionRebate;
    }

    public void setCommissionPrice(Double commissionPrice) {
        this.commissionPrice = commissionPrice;
    }

    public void setFinalPrice(Double finalPrice) {
        this.finalPrice = finalPrice;
    }

    public void setBillPrice(Double billPrice) {
        this.billPrice = billPrice;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setProfitSharing(String profitSharing) {
        this.profitSharing = profitSharing;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }

    public void setFullRefund(Boolean fullRefund) {
        this.fullRefund = fullRefund;
    }

    public String toString() {
        return "StoreFlow(sn=" + this.getSn() + ", orderSn=" + this.getOrderSn() + ", orderItemSn=" + this.getOrderItemSn() + ", refundSn=" + this.getRefundSn() + ", storeId=" + this.getStoreId() + ", storeName=" + this.getStoreName() + ", memberId=" + this.getMemberId() + ", memberName=" + this.getMemberName() + ", goodsId=" + this.getGoodsId() + ", goodsName=" + this.getGoodsName() + ", skuId=" + this.getSkuId() + ", image=" + this.getImage() + ", categoryId=" + this.getCategoryId() + ", specs=" + this.getSpecs() + ", flowType=" + this.getFlowType() + ", orderPromotionType=" + this.getOrderPromotionType() + ", pointSettlementPrice=" + this.getPointSettlementPrice() + ", kanjiaSettlementPrice=" + this.getKanjiaSettlementPrice() + ", siteCouponPrice=" + this.getSiteCouponPrice() + ", siteCouponPoint=" + this.getSiteCouponPoint() + ", siteCouponCommission=" + this.getSiteCouponCommission() + ", distributionRebate=" + this.getDistributionRebate() + ", commissionPrice=" + this.getCommissionPrice() + ", finalPrice=" + this.getFinalPrice() + ", billPrice=" + this.getBillPrice() + ", transactionId=" + this.getTransactionId() + ", paymentName=" + this.getPaymentName() + ", num=" + this.getNum() + ", createTime=" + this.getCreateTime() + ", profitSharing=" + this.getProfitSharing() + ", billTime=" + this.getBillTime() + ", fullRefund=" + this.getFullRefund() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoreFlow)) {
            return false;
        }
        StoreFlow other = (StoreFlow)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$pointSettlementPrice = this.getPointSettlementPrice();
        Double other$pointSettlementPrice = other.getPointSettlementPrice();
        if (this$pointSettlementPrice == null ? other$pointSettlementPrice != null : !((Object)this$pointSettlementPrice).equals(other$pointSettlementPrice)) {
            return false;
        }
        Double this$kanjiaSettlementPrice = this.getKanjiaSettlementPrice();
        Double other$kanjiaSettlementPrice = other.getKanjiaSettlementPrice();
        if (this$kanjiaSettlementPrice == null ? other$kanjiaSettlementPrice != null : !((Object)this$kanjiaSettlementPrice).equals(other$kanjiaSettlementPrice)) {
            return false;
        }
        Double this$siteCouponPrice = this.getSiteCouponPrice();
        Double other$siteCouponPrice = other.getSiteCouponPrice();
        if (this$siteCouponPrice == null ? other$siteCouponPrice != null : !((Object)this$siteCouponPrice).equals(other$siteCouponPrice)) {
            return false;
        }
        Double this$siteCouponPoint = this.getSiteCouponPoint();
        Double other$siteCouponPoint = other.getSiteCouponPoint();
        if (this$siteCouponPoint == null ? other$siteCouponPoint != null : !((Object)this$siteCouponPoint).equals(other$siteCouponPoint)) {
            return false;
        }
        Double this$siteCouponCommission = this.getSiteCouponCommission();
        Double other$siteCouponCommission = other.getSiteCouponCommission();
        if (this$siteCouponCommission == null ? other$siteCouponCommission != null : !((Object)this$siteCouponCommission).equals(other$siteCouponCommission)) {
            return false;
        }
        Double this$distributionRebate = this.getDistributionRebate();
        Double other$distributionRebate = other.getDistributionRebate();
        if (this$distributionRebate == null ? other$distributionRebate != null : !((Object)this$distributionRebate).equals(other$distributionRebate)) {
            return false;
        }
        Double this$commissionPrice = this.getCommissionPrice();
        Double other$commissionPrice = other.getCommissionPrice();
        if (this$commissionPrice == null ? other$commissionPrice != null : !((Object)this$commissionPrice).equals(other$commissionPrice)) {
            return false;
        }
        Double this$finalPrice = this.getFinalPrice();
        Double other$finalPrice = other.getFinalPrice();
        if (this$finalPrice == null ? other$finalPrice != null : !((Object)this$finalPrice).equals(other$finalPrice)) {
            return false;
        }
        Double this$billPrice = this.getBillPrice();
        Double other$billPrice = other.getBillPrice();
        if (this$billPrice == null ? other$billPrice != null : !((Object)this$billPrice).equals(other$billPrice)) {
            return false;
        }
        Integer this$num = this.getNum();
        Integer other$num = other.getNum();
        if (this$num == null ? other$num != null : !((Object)this$num).equals(other$num)) {
            return false;
        }
        Boolean this$fullRefund = this.getFullRefund();
        Boolean other$fullRefund = other.getFullRefund();
        if (this$fullRefund == null ? other$fullRefund != null : !((Object)this$fullRefund).equals(other$fullRefund)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        String this$orderSn = this.getOrderSn();
        String other$orderSn = other.getOrderSn();
        if (this$orderSn == null ? other$orderSn != null : !this$orderSn.equals(other$orderSn)) {
            return false;
        }
        String this$orderItemSn = this.getOrderItemSn();
        String other$orderItemSn = other.getOrderItemSn();
        if (this$orderItemSn == null ? other$orderItemSn != null : !this$orderItemSn.equals(other$orderItemSn)) {
            return false;
        }
        String this$refundSn = this.getRefundSn();
        String other$refundSn = other.getRefundSn();
        if (this$refundSn == null ? other$refundSn != null : !this$refundSn.equals(other$refundSn)) {
            return false;
        }
        String this$storeId = this.getStoreId();
        String other$storeId = other.getStoreId();
        if (this$storeId == null ? other$storeId != null : !this$storeId.equals(other$storeId)) {
            return false;
        }
        String this$storeName = this.getStoreName();
        String other$storeName = other.getStoreName();
        if (this$storeName == null ? other$storeName != null : !this$storeName.equals(other$storeName)) {
            return false;
        }
        String this$memberId = this.getMemberId();
        String other$memberId = other.getMemberId();
        if (this$memberId == null ? other$memberId != null : !this$memberId.equals(other$memberId)) {
            return false;
        }
        String this$memberName = this.getMemberName();
        String other$memberName = other.getMemberName();
        if (this$memberName == null ? other$memberName != null : !this$memberName.equals(other$memberName)) {
            return false;
        }
        String this$goodsId = this.getGoodsId();
        String other$goodsId = other.getGoodsId();
        if (this$goodsId == null ? other$goodsId != null : !this$goodsId.equals(other$goodsId)) {
            return false;
        }
        String this$goodsName = this.getGoodsName();
        String other$goodsName = other.getGoodsName();
        if (this$goodsName == null ? other$goodsName != null : !this$goodsName.equals(other$goodsName)) {
            return false;
        }
        String this$skuId = this.getSkuId();
        String other$skuId = other.getSkuId();
        if (this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$categoryId = this.getCategoryId();
        String other$categoryId = other.getCategoryId();
        if (this$categoryId == null ? other$categoryId != null : !this$categoryId.equals(other$categoryId)) {
            return false;
        }
        String this$specs = this.getSpecs();
        String other$specs = other.getSpecs();
        if (this$specs == null ? other$specs != null : !this$specs.equals(other$specs)) {
            return false;
        }
        String this$flowType = this.getFlowType();
        String other$flowType = other.getFlowType();
        if (this$flowType == null ? other$flowType != null : !this$flowType.equals(other$flowType)) {
            return false;
        }
        String this$orderPromotionType = this.getOrderPromotionType();
        String other$orderPromotionType = other.getOrderPromotionType();
        if (this$orderPromotionType == null ? other$orderPromotionType != null : !this$orderPromotionType.equals(other$orderPromotionType)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$paymentName = this.getPaymentName();
        String other$paymentName = other.getPaymentName();
        if (this$paymentName == null ? other$paymentName != null : !this$paymentName.equals(other$paymentName)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$profitSharing = this.getProfitSharing();
        String other$profitSharing = other.getProfitSharing();
        if (this$profitSharing == null ? other$profitSharing != null : !this$profitSharing.equals(other$profitSharing)) {
            return false;
        }
        Date this$billTime = this.getBillTime();
        Date other$billTime = other.getBillTime();
        return !(this$billTime == null ? other$billTime != null : !((Object)this$billTime).equals(other$billTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoreFlow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $pointSettlementPrice = this.getPointSettlementPrice();
        result = result * 59 + ($pointSettlementPrice == null ? 43 : ((Object)$pointSettlementPrice).hashCode());
        Double $kanjiaSettlementPrice = this.getKanjiaSettlementPrice();
        result = result * 59 + ($kanjiaSettlementPrice == null ? 43 : ((Object)$kanjiaSettlementPrice).hashCode());
        Double $siteCouponPrice = this.getSiteCouponPrice();
        result = result * 59 + ($siteCouponPrice == null ? 43 : ((Object)$siteCouponPrice).hashCode());
        Double $siteCouponPoint = this.getSiteCouponPoint();
        result = result * 59 + ($siteCouponPoint == null ? 43 : ((Object)$siteCouponPoint).hashCode());
        Double $siteCouponCommission = this.getSiteCouponCommission();
        result = result * 59 + ($siteCouponCommission == null ? 43 : ((Object)$siteCouponCommission).hashCode());
        Double $distributionRebate = this.getDistributionRebate();
        result = result * 59 + ($distributionRebate == null ? 43 : ((Object)$distributionRebate).hashCode());
        Double $commissionPrice = this.getCommissionPrice();
        result = result * 59 + ($commissionPrice == null ? 43 : ((Object)$commissionPrice).hashCode());
        Double $finalPrice = this.getFinalPrice();
        result = result * 59 + ($finalPrice == null ? 43 : ((Object)$finalPrice).hashCode());
        Double $billPrice = this.getBillPrice();
        result = result * 59 + ($billPrice == null ? 43 : ((Object)$billPrice).hashCode());
        Integer $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : ((Object)$num).hashCode());
        Boolean $fullRefund = this.getFullRefund();
        result = result * 59 + ($fullRefund == null ? 43 : ((Object)$fullRefund).hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        String $orderSn = this.getOrderSn();
        result = result * 59 + ($orderSn == null ? 43 : $orderSn.hashCode());
        String $orderItemSn = this.getOrderItemSn();
        result = result * 59 + ($orderItemSn == null ? 43 : $orderItemSn.hashCode());
        String $refundSn = this.getRefundSn();
        result = result * 59 + ($refundSn == null ? 43 : $refundSn.hashCode());
        String $storeId = this.getStoreId();
        result = result * 59 + ($storeId == null ? 43 : $storeId.hashCode());
        String $storeName = this.getStoreName();
        result = result * 59 + ($storeName == null ? 43 : $storeName.hashCode());
        String $memberId = this.getMemberId();
        result = result * 59 + ($memberId == null ? 43 : $memberId.hashCode());
        String $memberName = this.getMemberName();
        result = result * 59 + ($memberName == null ? 43 : $memberName.hashCode());
        String $goodsId = this.getGoodsId();
        result = result * 59 + ($goodsId == null ? 43 : $goodsId.hashCode());
        String $goodsName = this.getGoodsName();
        result = result * 59 + ($goodsName == null ? 43 : $goodsName.hashCode());
        String $skuId = this.getSkuId();
        result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $categoryId = this.getCategoryId();
        result = result * 59 + ($categoryId == null ? 43 : $categoryId.hashCode());
        String $specs = this.getSpecs();
        result = result * 59 + ($specs == null ? 43 : $specs.hashCode());
        String $flowType = this.getFlowType();
        result = result * 59 + ($flowType == null ? 43 : $flowType.hashCode());
        String $orderPromotionType = this.getOrderPromotionType();
        result = result * 59 + ($orderPromotionType == null ? 43 : $orderPromotionType.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $paymentName = this.getPaymentName();
        result = result * 59 + ($paymentName == null ? 43 : $paymentName.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $profitSharing = this.getProfitSharing();
        result = result * 59 + ($profitSharing == null ? 43 : $profitSharing.hashCode());
        Date $billTime = this.getBillTime();
        result = result * 59 + ($billTime == null ? 43 : ((Object)$billTime).hashCode());
        return result;
    }

    public StoreFlow() {
    }
}

