/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.promotion.client;

import cn.lili.modules.goods.entity.dto.GoodsSkuDTO;
import cn.lili.modules.promotion.entity.dos.Coupon;
import cn.lili.modules.promotion.entity.dos.MemberCoupon;
import cn.lili.modules.promotion.entity.dos.PromotionGoods;
import cn.lili.modules.promotion.entity.dto.search.KanjiaActivitySearchParams;
import cn.lili.modules.promotion.entity.dto.search.MemberCouponSearchParams;
import cn.lili.modules.promotion.entity.dto.search.PromotionGoodsSearchParams;
import cn.lili.modules.promotion.entity.vos.PintuanVO;
import cn.lili.modules.promotion.entity.vos.PointsGoodsVO;
import cn.lili.modules.promotion.entity.vos.kanjia.KanjiaActivityVO;
import cn.lili.modules.promotion.fallback.PromotionsFallback;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="promotion-service", contextId="promotions", fallback=PromotionsFallback.class)
public interface PromotionsClient {
    @PostMapping(value={"/feign/promotion/member/coupon/list"})
    public List<MemberCoupon> getMemberCoupons(@RequestBody MemberCouponSearchParams var1);

    @GetMapping(value={"/feign/promotion/member/coupon/list/{memberId}"})
    public List<MemberCoupon> getMemberCoupons(@PathVariable String var1);

    @PostMapping(value={"/feign/promotion/member/coupon/all/{memberId}"})
    public List<MemberCoupon> getAllScopeMemberCoupon(@PathVariable String var1, @RequestBody List<String> var2);

    @PostMapping(value={"/feign/promotion/member/coupon/one"})
    public MemberCoupon getMemberCoupon(@RequestBody MemberCouponSearchParams var1);

    @GetMapping(value={"/feign/promotion/points/{skuId}"})
    public PointsGoodsVO getPointsGoodsDetailBySkuId(@PathVariable String var1);

    @GetMapping(value={"/feign/promotion/pintuan/{id}"})
    public PintuanVO getPintuanVO(@PathVariable String var1);

    @PostMapping(value={"/feign/promotion/kanjia"})
    public KanjiaActivityVO getKanjiaActivityVO(@RequestBody KanjiaActivitySearchParams var1);

    @GetMapping(value={"/feign/promotion/member/coupon/can-use"})
    public List<MemberCoupon> getCurrentGoodsCanUse(@RequestParam String var1, @RequestParam List<String> var2, @RequestParam Double var3);

    @PostMapping(value={"/feign/promotion/goods/list"})
    public List<PromotionGoods> listFindAll(@RequestBody PromotionGoodsSearchParams var1);

    @PostMapping(value={"/feign/promotion/goods/get"})
    public PromotionGoods getPromotionsGoods(@RequestBody PromotionGoodsSearchParams var1);

    @GetMapping(value={"/feign/promotion/{goodsSkuId}/map"})
    public Map<String, Object> getGoodsSkuPromotionMap(@RequestParam String var1, @PathVariable String var2);

    @PutMapping(value={"/feign/promotion/coupon/{couponId}/used"})
    public void usedCoupon(@PathVariable String var1, @RequestParam Integer var2);

    @PutMapping(value={"/feign/promotion/removeByGoodsIds"})
    public void removeByGoodsIds(@RequestParam String var1);

    @PostMapping(value={"/feign/promotion/findSkuValidPromotions"})
    public List<PromotionGoods> findSkuValidPromotions(@RequestBody List<GoodsSkuDTO> var1);

    @PostMapping(value={"/feign/promotion/wrapperPromotionMapList"})
    public Map<String, Object> wrapperPromotionMapList(@RequestBody List<PromotionGoods> var1);

    @GetMapping(value={"/feign/promotion/getCouponById"})
    public Coupon getCouponById(@RequestParam String var1);

    @PutMapping(value={"/feign/promotion/deletePromotions"})
    public void deletePromotions(@RequestParam String var1);
}

