/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.promotion.entity.dos;

import cn.lili.modules.promotion.entity.enums.PromotionsScopeTypeEnum;
import cn.lili.modules.promotion.entity.enums.PromotionsStatusEnum;
import cn.lili.mybatis.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.NotEmpty;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

public class BasePromotions
extends BaseEntity {
    private static final long serialVersionUID = 7814832369110695758L;
    @ApiModelProperty(value="\u5546\u5bb6\u540d\u79f0\uff0c\u5982\u679c\u662f\u5e73\u53f0\uff0c\u8fd9\u4e2a\u503c\u4e3a platform")
    private String storeName;
    @ApiModelProperty(value="\u5546\u5bb6id\uff0c\u5982\u679c\u662f\u5e73\u53f0\uff0c\u8fd9\u4e2a\u503c\u4e3a 0")
    private String storeId;
    @NotEmpty(message="\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @ApiModelProperty(value="\u6d3b\u52a8\u540d\u79f0", required=true)
    private @NotEmpty(message="\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String promotionName;
    @ApiModelProperty(value="\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", required=true)
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @Field(type=FieldType.Date, format={DateFormat.custom}, pattern={"yyyy-MM-dd HH:mm:ss || yyyy-MM-dd || yyyy/MM/dd HH:mm:ss|| yyyy/MM/dd ||epoch_millis"})
    private Date startTime;
    @ApiModelProperty(value="\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4", required=true)
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    @Field(type=FieldType.Date, format={DateFormat.custom}, pattern={"yyyy-MM-dd HH:mm:ss || yyyy-MM-dd || yyyy/MM/dd HH:mm:ss|| yyyy/MM/dd ||epoch_millis"})
    private Date endTime;
    @ApiModelProperty(value="\u5173\u8054\u8303\u56f4\u7c7b\u578b")
    private String scopeType = PromotionsScopeTypeEnum.PORTION_GOODS.name();
    @ApiModelProperty(value="\u8303\u56f4\u5173\u8054\u7684id")
    private String scopeId;

    public String getPromotionStatus() {
        if (this.endTime == null) {
            return this.startTime != null ? PromotionsStatusEnum.START.name() : PromotionsStatusEnum.CLOSE.name();
        }
        Date now = new Date();
        if (now.before(this.startTime)) {
            return PromotionsStatusEnum.NEW.name();
        }
        if (this.endTime.before(now)) {
            return PromotionsStatusEnum.END.name();
        }
        if (now.before(this.endTime)) {
            return PromotionsStatusEnum.START.name();
        }
        return PromotionsStatusEnum.CLOSE.name();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePromotions)) {
            return false;
        }
        BasePromotions other = (BasePromotions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$storeName = this.getStoreName();
        String other$storeName = other.getStoreName();
        if (this$storeName == null ? other$storeName != null : !this$storeName.equals(other$storeName)) {
            return false;
        }
        String this$storeId = this.getStoreId();
        String other$storeId = other.getStoreId();
        if (this$storeId == null ? other$storeId != null : !this$storeId.equals(other$storeId)) {
            return false;
        }
        String this$promotionName = this.getPromotionName();
        String other$promotionName = other.getPromotionName();
        if (this$promotionName == null ? other$promotionName != null : !this$promotionName.equals(other$promotionName)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$scopeType = this.getScopeType();
        String other$scopeType = other.getScopeType();
        if (this$scopeType == null ? other$scopeType != null : !this$scopeType.equals(other$scopeType)) {
            return false;
        }
        String this$scopeId = this.getScopeId();
        String other$scopeId = other.getScopeId();
        return !(this$scopeId == null ? other$scopeId != null : !this$scopeId.equals(other$scopeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePromotions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $storeName = this.getStoreName();
        result = result * 59 + ($storeName == null ? 43 : $storeName.hashCode());
        String $storeId = this.getStoreId();
        result = result * 59 + ($storeId == null ? 43 : $storeId.hashCode());
        String $promotionName = this.getPromotionName();
        result = result * 59 + ($promotionName == null ? 43 : $promotionName.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $scopeType = this.getScopeType();
        result = result * 59 + ($scopeType == null ? 43 : $scopeType.hashCode());
        String $scopeId = this.getScopeId();
        result = result * 59 + ($scopeId == null ? 43 : $scopeId.hashCode());
        return result;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getPromotionName() {
        return this.promotionName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setPromotionName(String promotionName) {
        this.promotionName = promotionName;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String toString() {
        return "BasePromotions(storeName=" + this.getStoreName() + ", storeId=" + this.getStoreId() + ", promotionName=" + this.getPromotionName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", scopeType=" + this.getScopeType() + ", scopeId=" + this.getScopeId() + ")";
    }
}

