/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.search.entity.dos;

import cn.hutool.json.JSONUtil;
import cn.lili.modules.goods.entity.dos.GoodsSku;
import cn.lili.modules.goods.entity.dto.GoodsParamsDTO;
import cn.lili.modules.promotion.tools.PromotionTools;
import cn.lili.modules.search.entity.dos.EsGoodsAttribute;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="#{@elasticsearchProperties.indexPrefix}_goods", createIndex=false)
public class EsGoodsIndex
implements Serializable {
    private static final long serialVersionUID = -6856471777036048874L;
    @Id
    @ApiModelProperty(value="\u5546\u54c1skuId")
    private String id;
    @ApiModelProperty(value="\u5546\u54c1Id")
    @Field(type=FieldType.Text)
    private String goodsId;
    @Field(type=FieldType.Text, analyzer="ik_max_word")
    @ApiModelProperty(value="\u5546\u54c1\u540d\u79f0")
    private String goodsName;
    @Field(type=FieldType.Keyword)
    @ApiModelProperty(value="\u5546\u54c1\u7f16\u53f7")
    private String sn;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u5356\u5bb6id")
    private String storeId;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u5356\u5bb6\u540d\u79f0")
    private String storeName;
    @Field(type=FieldType.Integer)
    @ApiModelProperty(value="\u9500\u91cf")
    private Integer buyCount;
    @ApiModelProperty(value="\u5c0f\u56fe")
    private String small;
    @ApiModelProperty(value="\u7f29\u7565\u56fe")
    private String thumbnail;
    @Field(type=FieldType.Text, fielddata=true)
    @ApiModelProperty(value="\u54c1\u724cid")
    private String brandId;
    @Field(type=FieldType.Text, fielddata=true)
    @ApiModelProperty(value="\u54c1\u724c\u540d\u79f0")
    private String brandName;
    @Field(type=FieldType.Text, fielddata=true)
    @ApiModelProperty(value="\u54c1\u724c\u56fe\u7247\u5730\u5740")
    private String brandUrl;
    @Field(type=FieldType.Text, fielddata=true)
    @ApiModelProperty(value="\u5206\u7c7bpath")
    private String categoryPath;
    @Field(type=FieldType.Text, fielddata=true)
    @ApiModelProperty(value="\u5206\u7c7b\u540d\u79f0path")
    private String categoryNamePath;
    @Field(type=FieldType.Text, fielddata=true)
    @ApiModelProperty(value="\u5e97\u94fa\u5206\u7c7bid")
    private String storeCategoryPath;
    @Field(type=FieldType.Keyword)
    @ApiModelProperty(value="\u5e97\u94fa\u5206\u7c7b\u540d\u79f0")
    private String storeCategoryNamePath;
    @Field(type=FieldType.Double)
    @ApiModelProperty(value="\u5546\u54c1\u4ef7\u683c")
    private Double price;
    @Field(type=FieldType.Double)
    @ApiModelProperty(value="\u4fc3\u9500\u4ef7")
    private Double promotionPrice;
    @Field(type=FieldType.Integer)
    @ApiModelProperty(value="\u79ef\u5206\u5546\u54c1\u9700\u8981\u4f7f\u7528\u7684\u79ef\u5206")
    private Integer point;
    @Field(type=FieldType.Integer)
    @ApiModelProperty(value="\u8bc4\u4ef7\u6570\u91cf")
    private Integer commentNum;
    @Field(type=FieldType.Integer)
    @ApiModelProperty(value="\u597d\u8bc4\u6570\u91cf")
    private Integer highPraiseNum;
    @Field(type=FieldType.Double)
    @ApiModelProperty(value="\u597d\u8bc4\u7387")
    private Double grade;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u8be6\u60c5")
    private String intro;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u5546\u54c1\u79fb\u52a8\u7aef\u8be6\u60c5")
    private String mobileIntro;
    @Field(type=FieldType.Boolean)
    @ApiModelProperty(value="\u662f\u5426\u81ea\u8425")
    private Boolean selfOperated;
    @Field(type=FieldType.Boolean)
    @ApiModelProperty(value="\u662f\u5426\u4e3a\u63a8\u8350\u5546\u54c1")
    private Boolean recommend;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u9500\u552e\u6a21\u5f0f")
    private String salesModel;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u5ba1\u6838\u72b6\u6001")
    private String authFlag;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u5356\u70b9")
    private String sellingPoint;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u4e0a\u67b6\u72b6\u6001")
    private String marketEnable;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u5546\u54c1\u89c6\u9891")
    private String goodsVideo;
    @ApiModelProperty(value="\u5546\u54c1\u53d1\u5e03\u65f6\u95f4")
    @Field(type=FieldType.Date)
    private Long releaseTime;
    @ApiModelProperty(value="\u5546\u54c1\u7c7b\u578b", required=true)
    @Field(type=FieldType.Text)
    private String goodsType;
    @ApiModelProperty(value="\u5546\u54c1sku\u57fa\u7840\u5206\u6570", required=true)
    @Field(type=FieldType.Integer)
    private Integer skuSource;
    @Field(type=FieldType.Nested)
    private List<EsGoodsAttribute> attrList;
    @Field(type=FieldType.Text)
    @ApiModelProperty(value="\u5546\u54c1\u4fc3\u9500\u6d3b\u52a8\u96c6\u5408JSON\uff0ckey \u4e3a \u4fc3\u9500\u6d3b\u52a8\u7c7b\u578b\uff0cvalue \u4e3a \u4fc3\u9500\u6d3b\u52a8\u5b9e\u4f53\u4fe1\u606f ")
    private String promotionMapJson;

    public EsGoodsIndex(GoodsSku sku) {
        if (sku != null) {
            this.id = sku.getId();
            this.goodsId = sku.getGoodsId();
            this.goodsName = sku.getGoodsName();
            this.price = sku.getPrice();
            this.storeName = sku.getStoreName();
            this.storeId = sku.getStoreId();
            this.thumbnail = sku.getThumbnail();
            this.categoryPath = sku.getCategoryPath();
            this.goodsVideo = sku.getGoodsVideo();
            this.mobileIntro = sku.getMobileIntro();
            this.buyCount = sku.getBuyCount() != null ? sku.getBuyCount() : 0;
            this.commentNum = sku.getCommentNum();
            this.small = sku.getSmall();
            this.brandId = sku.getBrandId();
            this.sn = sku.getSn();
            this.storeCategoryPath = sku.getStoreCategoryPath();
            this.sellingPoint = sku.getSellingPoint();
            this.selfOperated = sku.getSelfOperated();
            this.salesModel = sku.getSalesModel();
            this.marketEnable = sku.getMarketEnable();
            this.authFlag = sku.getAuthFlag();
            this.intro = sku.getIntro();
            this.grade = sku.getGrade();
            this.recommend = sku.getRecommend();
            this.goodsType = sku.getGoodsType();
            this.releaseTime = new Date().getTime();
        }
    }

    public EsGoodsIndex(GoodsSku sku, List<GoodsParamsDTO> goodsParamDTOS) {
        this(sku);
        if (goodsParamDTOS != null && !goodsParamDTOS.isEmpty()) {
            ArrayList<EsGoodsAttribute> attributes = new ArrayList<EsGoodsAttribute>();
            goodsParamDTOS.forEach(goodsParamGroup -> {
                if (goodsParamGroup.getGoodsParamsItemDTOList() != null && !goodsParamGroup.getGoodsParamsItemDTOList().isEmpty()) {
                    goodsParamGroup.getGoodsParamsItemDTOList().forEach(goodsParam -> {
                        if (goodsParam.getIsIndex() != null && goodsParam.getIsIndex() == 1) {
                            EsGoodsAttribute attribute = new EsGoodsAttribute();
                            attribute.setType(1);
                            attribute.setName(goodsParam.getParamName());
                            attribute.setValue(goodsParam.getParamValue());
                            attribute.setSort(goodsParam.getSort());
                            attributes.add(attribute);
                        }
                    });
                }
            });
            this.attrList = attributes;
        }
    }

    public EsGoodsIndex(GoodsSku sku, Date createDate) {
        this(sku);
        this.releaseTime = createDate.getTime();
    }

    public void setGoodsSku(GoodsSku sku) {
        if (sku != null) {
            this.id = sku.getId();
            this.goodsId = sku.getGoodsId();
            this.goodsName = sku.getGoodsName();
            this.price = sku.getPrice();
            this.storeName = sku.getStoreName();
            this.storeId = sku.getStoreId();
            this.thumbnail = sku.getThumbnail();
            this.categoryPath = sku.getCategoryPath();
            this.goodsVideo = sku.getGoodsVideo();
            this.mobileIntro = sku.getMobileIntro();
            this.buyCount = sku.getBuyCount();
            this.commentNum = sku.getCommentNum();
            this.small = sku.getSmall();
            this.brandId = sku.getBrandId();
            this.sn = sku.getSn();
            this.storeCategoryPath = sku.getStoreCategoryPath();
            this.sellingPoint = sku.getSellingPoint();
            this.selfOperated = sku.getSelfOperated();
            this.salesModel = sku.getSalesModel();
            this.marketEnable = sku.getMarketEnable();
            this.authFlag = sku.getAuthFlag();
            this.intro = sku.getIntro();
            this.grade = sku.getGrade();
            this.releaseTime = new Date().getTime();
        }
    }

    public Map<String, Object> getOriginPromotionMap() {
        return JSONUtil.parseObj((String)this.promotionMapJson);
    }

    public Map<String, Object> getPromotionMap() {
        return PromotionTools.filterInvalidPromotionsMap((Map<String, Object>)JSONUtil.parseObj((String)this.promotionMapJson));
    }

    public String getId() {
        return this.id;
    }

    public String getGoodsId() {
        return this.goodsId;
    }

    public String getGoodsName() {
        return this.goodsName;
    }

    public String getSn() {
        return this.sn;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public Integer getBuyCount() {
        return this.buyCount;
    }

    public String getSmall() {
        return this.small;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public String getBrandId() {
        return this.brandId;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public String getBrandUrl() {
        return this.brandUrl;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public String getCategoryNamePath() {
        return this.categoryNamePath;
    }

    public String getStoreCategoryPath() {
        return this.storeCategoryPath;
    }

    public String getStoreCategoryNamePath() {
        return this.storeCategoryNamePath;
    }

    public Double getPrice() {
        return this.price;
    }

    public Double getPromotionPrice() {
        return this.promotionPrice;
    }

    public Integer getPoint() {
        return this.point;
    }

    public Integer getCommentNum() {
        return this.commentNum;
    }

    public Integer getHighPraiseNum() {
        return this.highPraiseNum;
    }

    public Double getGrade() {
        return this.grade;
    }

    public String getIntro() {
        return this.intro;
    }

    public String getMobileIntro() {
        return this.mobileIntro;
    }

    public Boolean getSelfOperated() {
        return this.selfOperated;
    }

    public Boolean getRecommend() {
        return this.recommend;
    }

    public String getSalesModel() {
        return this.salesModel;
    }

    public String getAuthFlag() {
        return this.authFlag;
    }

    public String getSellingPoint() {
        return this.sellingPoint;
    }

    public String getMarketEnable() {
        return this.marketEnable;
    }

    public String getGoodsVideo() {
        return this.goodsVideo;
    }

    public Long getReleaseTime() {
        return this.releaseTime;
    }

    public String getGoodsType() {
        return this.goodsType;
    }

    public Integer getSkuSource() {
        return this.skuSource;
    }

    public List<EsGoodsAttribute> getAttrList() {
        return this.attrList;
    }

    public String getPromotionMapJson() {
        return this.promotionMapJson;
    }

    public EsGoodsIndex setId(String id) {
        this.id = id;
        return this;
    }

    public EsGoodsIndex setGoodsId(String goodsId) {
        this.goodsId = goodsId;
        return this;
    }

    public EsGoodsIndex setGoodsName(String goodsName) {
        this.goodsName = goodsName;
        return this;
    }

    public EsGoodsIndex setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public EsGoodsIndex setStoreId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    public EsGoodsIndex setStoreName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    public EsGoodsIndex setBuyCount(Integer buyCount) {
        this.buyCount = buyCount;
        return this;
    }

    public EsGoodsIndex setSmall(String small) {
        this.small = small;
        return this;
    }

    public EsGoodsIndex setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public EsGoodsIndex setBrandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    public EsGoodsIndex setBrandName(String brandName) {
        this.brandName = brandName;
        return this;
    }

    public EsGoodsIndex setBrandUrl(String brandUrl) {
        this.brandUrl = brandUrl;
        return this;
    }

    public EsGoodsIndex setCategoryPath(String categoryPath) {
        this.categoryPath = categoryPath;
        return this;
    }

    public EsGoodsIndex setCategoryNamePath(String categoryNamePath) {
        this.categoryNamePath = categoryNamePath;
        return this;
    }

    public EsGoodsIndex setStoreCategoryPath(String storeCategoryPath) {
        this.storeCategoryPath = storeCategoryPath;
        return this;
    }

    public EsGoodsIndex setStoreCategoryNamePath(String storeCategoryNamePath) {
        this.storeCategoryNamePath = storeCategoryNamePath;
        return this;
    }

    public EsGoodsIndex setPrice(Double price) {
        this.price = price;
        return this;
    }

    public EsGoodsIndex setPromotionPrice(Double promotionPrice) {
        this.promotionPrice = promotionPrice;
        return this;
    }

    public EsGoodsIndex setPoint(Integer point) {
        this.point = point;
        return this;
    }

    public EsGoodsIndex setCommentNum(Integer commentNum) {
        this.commentNum = commentNum;
        return this;
    }

    public EsGoodsIndex setHighPraiseNum(Integer highPraiseNum) {
        this.highPraiseNum = highPraiseNum;
        return this;
    }

    public EsGoodsIndex setGrade(Double grade) {
        this.grade = grade;
        return this;
    }

    public EsGoodsIndex setIntro(String intro) {
        this.intro = intro;
        return this;
    }

    public EsGoodsIndex setMobileIntro(String mobileIntro) {
        this.mobileIntro = mobileIntro;
        return this;
    }

    public EsGoodsIndex setSelfOperated(Boolean selfOperated) {
        this.selfOperated = selfOperated;
        return this;
    }

    public EsGoodsIndex setRecommend(Boolean recommend) {
        this.recommend = recommend;
        return this;
    }

    public EsGoodsIndex setSalesModel(String salesModel) {
        this.salesModel = salesModel;
        return this;
    }

    public EsGoodsIndex setAuthFlag(String authFlag) {
        this.authFlag = authFlag;
        return this;
    }

    public EsGoodsIndex setSellingPoint(String sellingPoint) {
        this.sellingPoint = sellingPoint;
        return this;
    }

    public EsGoodsIndex setMarketEnable(String marketEnable) {
        this.marketEnable = marketEnable;
        return this;
    }

    public EsGoodsIndex setGoodsVideo(String goodsVideo) {
        this.goodsVideo = goodsVideo;
        return this;
    }

    public EsGoodsIndex setReleaseTime(Long releaseTime) {
        this.releaseTime = releaseTime;
        return this;
    }

    public EsGoodsIndex setGoodsType(String goodsType) {
        this.goodsType = goodsType;
        return this;
    }

    public EsGoodsIndex setSkuSource(Integer skuSource) {
        this.skuSource = skuSource;
        return this;
    }

    public EsGoodsIndex setAttrList(List<EsGoodsAttribute> attrList) {
        this.attrList = attrList;
        return this;
    }

    public EsGoodsIndex setPromotionMapJson(String promotionMapJson) {
        this.promotionMapJson = promotionMapJson;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsGoodsIndex)) {
            return false;
        }
        EsGoodsIndex other = (EsGoodsIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$buyCount = this.getBuyCount();
        Integer other$buyCount = other.getBuyCount();
        if (this$buyCount == null ? other$buyCount != null : !((Object)this$buyCount).equals(other$buyCount)) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Double this$promotionPrice = this.getPromotionPrice();
        Double other$promotionPrice = other.getPromotionPrice();
        if (this$promotionPrice == null ? other$promotionPrice != null : !((Object)this$promotionPrice).equals(other$promotionPrice)) {
            return false;
        }
        Integer this$point = this.getPoint();
        Integer other$point = other.getPoint();
        if (this$point == null ? other$point != null : !((Object)this$point).equals(other$point)) {
            return false;
        }
        Integer this$commentNum = this.getCommentNum();
        Integer other$commentNum = other.getCommentNum();
        if (this$commentNum == null ? other$commentNum != null : !((Object)this$commentNum).equals(other$commentNum)) {
            return false;
        }
        Integer this$highPraiseNum = this.getHighPraiseNum();
        Integer other$highPraiseNum = other.getHighPraiseNum();
        if (this$highPraiseNum == null ? other$highPraiseNum != null : !((Object)this$highPraiseNum).equals(other$highPraiseNum)) {
            return false;
        }
        Double this$grade = this.getGrade();
        Double other$grade = other.getGrade();
        if (this$grade == null ? other$grade != null : !((Object)this$grade).equals(other$grade)) {
            return false;
        }
        Boolean this$selfOperated = this.getSelfOperated();
        Boolean other$selfOperated = other.getSelfOperated();
        if (this$selfOperated == null ? other$selfOperated != null : !((Object)this$selfOperated).equals(other$selfOperated)) {
            return false;
        }
        Boolean this$recommend = this.getRecommend();
        Boolean other$recommend = other.getRecommend();
        if (this$recommend == null ? other$recommend != null : !((Object)this$recommend).equals(other$recommend)) {
            return false;
        }
        Long this$releaseTime = this.getReleaseTime();
        Long other$releaseTime = other.getReleaseTime();
        if (this$releaseTime == null ? other$releaseTime != null : !((Object)this$releaseTime).equals(other$releaseTime)) {
            return false;
        }
        Integer this$skuSource = this.getSkuSource();
        Integer other$skuSource = other.getSkuSource();
        if (this$skuSource == null ? other$skuSource != null : !((Object)this$skuSource).equals(other$skuSource)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$goodsId = this.getGoodsId();
        String other$goodsId = other.getGoodsId();
        if (this$goodsId == null ? other$goodsId != null : !this$goodsId.equals(other$goodsId)) {
            return false;
        }
        String this$goodsName = this.getGoodsName();
        String other$goodsName = other.getGoodsName();
        if (this$goodsName == null ? other$goodsName != null : !this$goodsName.equals(other$goodsName)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        String this$storeId = this.getStoreId();
        String other$storeId = other.getStoreId();
        if (this$storeId == null ? other$storeId != null : !this$storeId.equals(other$storeId)) {
            return false;
        }
        String this$storeName = this.getStoreName();
        String other$storeName = other.getStoreName();
        if (this$storeName == null ? other$storeName != null : !this$storeName.equals(other$storeName)) {
            return false;
        }
        String this$small = this.getSmall();
        String other$small = other.getSmall();
        if (this$small == null ? other$small != null : !this$small.equals(other$small)) {
            return false;
        }
        String this$thumbnail = this.getThumbnail();
        String other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !this$thumbnail.equals(other$thumbnail)) {
            return false;
        }
        String this$brandId = this.getBrandId();
        String other$brandId = other.getBrandId();
        if (this$brandId == null ? other$brandId != null : !this$brandId.equals(other$brandId)) {
            return false;
        }
        String this$brandName = this.getBrandName();
        String other$brandName = other.getBrandName();
        if (this$brandName == null ? other$brandName != null : !this$brandName.equals(other$brandName)) {
            return false;
        }
        String this$brandUrl = this.getBrandUrl();
        String other$brandUrl = other.getBrandUrl();
        if (this$brandUrl == null ? other$brandUrl != null : !this$brandUrl.equals(other$brandUrl)) {
            return false;
        }
        String this$categoryPath = this.getCategoryPath();
        String other$categoryPath = other.getCategoryPath();
        if (this$categoryPath == null ? other$categoryPath != null : !this$categoryPath.equals(other$categoryPath)) {
            return false;
        }
        String this$categoryNamePath = this.getCategoryNamePath();
        String other$categoryNamePath = other.getCategoryNamePath();
        if (this$categoryNamePath == null ? other$categoryNamePath != null : !this$categoryNamePath.equals(other$categoryNamePath)) {
            return false;
        }
        String this$storeCategoryPath = this.getStoreCategoryPath();
        String other$storeCategoryPath = other.getStoreCategoryPath();
        if (this$storeCategoryPath == null ? other$storeCategoryPath != null : !this$storeCategoryPath.equals(other$storeCategoryPath)) {
            return false;
        }
        String this$storeCategoryNamePath = this.getStoreCategoryNamePath();
        String other$storeCategoryNamePath = other.getStoreCategoryNamePath();
        if (this$storeCategoryNamePath == null ? other$storeCategoryNamePath != null : !this$storeCategoryNamePath.equals(other$storeCategoryNamePath)) {
            return false;
        }
        String this$intro = this.getIntro();
        String other$intro = other.getIntro();
        if (this$intro == null ? other$intro != null : !this$intro.equals(other$intro)) {
            return false;
        }
        String this$mobileIntro = this.getMobileIntro();
        String other$mobileIntro = other.getMobileIntro();
        if (this$mobileIntro == null ? other$mobileIntro != null : !this$mobileIntro.equals(other$mobileIntro)) {
            return false;
        }
        String this$salesModel = this.getSalesModel();
        String other$salesModel = other.getSalesModel();
        if (this$salesModel == null ? other$salesModel != null : !this$salesModel.equals(other$salesModel)) {
            return false;
        }
        String this$authFlag = this.getAuthFlag();
        String other$authFlag = other.getAuthFlag();
        if (this$authFlag == null ? other$authFlag != null : !this$authFlag.equals(other$authFlag)) {
            return false;
        }
        String this$sellingPoint = this.getSellingPoint();
        String other$sellingPoint = other.getSellingPoint();
        if (this$sellingPoint == null ? other$sellingPoint != null : !this$sellingPoint.equals(other$sellingPoint)) {
            return false;
        }
        String this$marketEnable = this.getMarketEnable();
        String other$marketEnable = other.getMarketEnable();
        if (this$marketEnable == null ? other$marketEnable != null : !this$marketEnable.equals(other$marketEnable)) {
            return false;
        }
        String this$goodsVideo = this.getGoodsVideo();
        String other$goodsVideo = other.getGoodsVideo();
        if (this$goodsVideo == null ? other$goodsVideo != null : !this$goodsVideo.equals(other$goodsVideo)) {
            return false;
        }
        String this$goodsType = this.getGoodsType();
        String other$goodsType = other.getGoodsType();
        if (this$goodsType == null ? other$goodsType != null : !this$goodsType.equals(other$goodsType)) {
            return false;
        }
        List<EsGoodsAttribute> this$attrList = this.getAttrList();
        List<EsGoodsAttribute> other$attrList = other.getAttrList();
        if (this$attrList == null ? other$attrList != null : !((Object)this$attrList).equals(other$attrList)) {
            return false;
        }
        String this$promotionMapJson = this.getPromotionMapJson();
        String other$promotionMapJson = other.getPromotionMapJson();
        return !(this$promotionMapJson == null ? other$promotionMapJson != null : !this$promotionMapJson.equals(other$promotionMapJson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EsGoodsIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $buyCount = this.getBuyCount();
        result = result * 59 + ($buyCount == null ? 43 : ((Object)$buyCount).hashCode());
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Double $promotionPrice = this.getPromotionPrice();
        result = result * 59 + ($promotionPrice == null ? 43 : ((Object)$promotionPrice).hashCode());
        Integer $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : ((Object)$point).hashCode());
        Integer $commentNum = this.getCommentNum();
        result = result * 59 + ($commentNum == null ? 43 : ((Object)$commentNum).hashCode());
        Integer $highPraiseNum = this.getHighPraiseNum();
        result = result * 59 + ($highPraiseNum == null ? 43 : ((Object)$highPraiseNum).hashCode());
        Double $grade = this.getGrade();
        result = result * 59 + ($grade == null ? 43 : ((Object)$grade).hashCode());
        Boolean $selfOperated = this.getSelfOperated();
        result = result * 59 + ($selfOperated == null ? 43 : ((Object)$selfOperated).hashCode());
        Boolean $recommend = this.getRecommend();
        result = result * 59 + ($recommend == null ? 43 : ((Object)$recommend).hashCode());
        Long $releaseTime = this.getReleaseTime();
        result = result * 59 + ($releaseTime == null ? 43 : ((Object)$releaseTime).hashCode());
        Integer $skuSource = this.getSkuSource();
        result = result * 59 + ($skuSource == null ? 43 : ((Object)$skuSource).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $goodsId = this.getGoodsId();
        result = result * 59 + ($goodsId == null ? 43 : $goodsId.hashCode());
        String $goodsName = this.getGoodsName();
        result = result * 59 + ($goodsName == null ? 43 : $goodsName.hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        String $storeId = this.getStoreId();
        result = result * 59 + ($storeId == null ? 43 : $storeId.hashCode());
        String $storeName = this.getStoreName();
        result = result * 59 + ($storeName == null ? 43 : $storeName.hashCode());
        String $small = this.getSmall();
        result = result * 59 + ($small == null ? 43 : $small.hashCode());
        String $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : $thumbnail.hashCode());
        String $brandId = this.getBrandId();
        result = result * 59 + ($brandId == null ? 43 : $brandId.hashCode());
        String $brandName = this.getBrandName();
        result = result * 59 + ($brandName == null ? 43 : $brandName.hashCode());
        String $brandUrl = this.getBrandUrl();
        result = result * 59 + ($brandUrl == null ? 43 : $brandUrl.hashCode());
        String $categoryPath = this.getCategoryPath();
        result = result * 59 + ($categoryPath == null ? 43 : $categoryPath.hashCode());
        String $categoryNamePath = this.getCategoryNamePath();
        result = result * 59 + ($categoryNamePath == null ? 43 : $categoryNamePath.hashCode());
        String $storeCategoryPath = this.getStoreCategoryPath();
        result = result * 59 + ($storeCategoryPath == null ? 43 : $storeCategoryPath.hashCode());
        String $storeCategoryNamePath = this.getStoreCategoryNamePath();
        result = result * 59 + ($storeCategoryNamePath == null ? 43 : $storeCategoryNamePath.hashCode());
        String $intro = this.getIntro();
        result = result * 59 + ($intro == null ? 43 : $intro.hashCode());
        String $mobileIntro = this.getMobileIntro();
        result = result * 59 + ($mobileIntro == null ? 43 : $mobileIntro.hashCode());
        String $salesModel = this.getSalesModel();
        result = result * 59 + ($salesModel == null ? 43 : $salesModel.hashCode());
        String $authFlag = this.getAuthFlag();
        result = result * 59 + ($authFlag == null ? 43 : $authFlag.hashCode());
        String $sellingPoint = this.getSellingPoint();
        result = result * 59 + ($sellingPoint == null ? 43 : $sellingPoint.hashCode());
        String $marketEnable = this.getMarketEnable();
        result = result * 59 + ($marketEnable == null ? 43 : $marketEnable.hashCode());
        String $goodsVideo = this.getGoodsVideo();
        result = result * 59 + ($goodsVideo == null ? 43 : $goodsVideo.hashCode());
        String $goodsType = this.getGoodsType();
        result = result * 59 + ($goodsType == null ? 43 : $goodsType.hashCode());
        List<EsGoodsAttribute> $attrList = this.getAttrList();
        result = result * 59 + ($attrList == null ? 43 : ((Object)$attrList).hashCode());
        String $promotionMapJson = this.getPromotionMapJson();
        result = result * 59 + ($promotionMapJson == null ? 43 : $promotionMapJson.hashCode());
        return result;
    }

    public String toString() {
        return "EsGoodsIndex(id=" + this.getId() + ", goodsId=" + this.getGoodsId() + ", goodsName=" + this.getGoodsName() + ", sn=" + this.getSn() + ", storeId=" + this.getStoreId() + ", storeName=" + this.getStoreName() + ", buyCount=" + this.getBuyCount() + ", small=" + this.getSmall() + ", thumbnail=" + this.getThumbnail() + ", brandId=" + this.getBrandId() + ", brandName=" + this.getBrandName() + ", brandUrl=" + this.getBrandUrl() + ", categoryPath=" + this.getCategoryPath() + ", categoryNamePath=" + this.getCategoryNamePath() + ", storeCategoryPath=" + this.getStoreCategoryPath() + ", storeCategoryNamePath=" + this.getStoreCategoryNamePath() + ", price=" + this.getPrice() + ", promotionPrice=" + this.getPromotionPrice() + ", point=" + this.getPoint() + ", commentNum=" + this.getCommentNum() + ", highPraiseNum=" + this.getHighPraiseNum() + ", grade=" + this.getGrade() + ", intro=" + this.getIntro() + ", mobileIntro=" + this.getMobileIntro() + ", selfOperated=" + this.getSelfOperated() + ", recommend=" + this.getRecommend() + ", salesModel=" + this.getSalesModel() + ", authFlag=" + this.getAuthFlag() + ", sellingPoint=" + this.getSellingPoint() + ", marketEnable=" + this.getMarketEnable() + ", goodsVideo=" + this.getGoodsVideo() + ", releaseTime=" + this.getReleaseTime() + ", goodsType=" + this.getGoodsType() + ", skuSource=" + this.getSkuSource() + ", attrList=" + this.getAttrList() + ", promotionMapJson=" + this.getPromotionMapJson() + ")";
    }

    public EsGoodsIndex() {
    }
}

