package cn.lili.modules.distribution.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.distribution.fallback.DistributionSelectedGoodsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author: ftyy
 * @date: 2022-01-14 10:31
 * @description: 分销商已选择分销商品Client
 */
@FeignClient(name = ServiceConstant.DISTRIBUTION_SERVICE, contextId = "distribution-selected-goods", fallback = DistributionSelectedGoodsFallback.class)
public interface DistributionSelectedGoodsClient {
    /**
     * 分销员添加分销商品
     *
     * @param distributionGoodsId 分销商品ID
     * @return 是否添加成功
     */
    @PostMapping("/feign/distribution/distribution-selected-goods/add/{distributionGoodsId}")
    boolean add(@PathVariable String distributionGoodsId);

    /**
     * 分销员删除分销商品
     *
     * @param distributionGoodsId 分销商品ID
     * @return 是否删除成功
     */
    @DeleteMapping("/feign/distribution/distribution-selected-goods/delete/{distributionGoodsId}")
    boolean delete(@PathVariable String distributionGoodsId);

    /**
     * 分销员删除分销商品（管理员操作）
     *
     * @param distributionGoodsId 分销商品ID
     * @return 是否删除成功
     */
    @DeleteMapping("/feign/distribution/distribution-selected-goods/deleteByDistributionGoodsId/{distributionGoodsId}")
    boolean deleteByDistributionGoodsId(@PathVariable String distributionGoodsId);
}

