package cn.lili.modules.file.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.file.entity.dto.FileUploadDTO;
import cn.lili.modules.goods.fallback.BrandFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author: ftyy
 * @date: 2022-01-14 10:38
 * @description: 上传Client
 */
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "upload", fallback = BrandFallback.class)
public interface UploadClient {

    /**
     * 上传数据
     *
     * @return 更新结果
     */
    @PutMapping("/feign/file/upload")
    String upload(@RequestBody FileUploadDTO fileUploadDTO);
}
