package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dos.Category;
import cn.lili.modules.goods.fallback.CategoryFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 商品服务分类client
 *
 * @author Chopper
 * @version v1.0 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "category", fallback = CategoryFallback.class)
public interface CategoryClient {

    /**
     * 获取一级分类列表 用于商家入驻选择
     *
     * @return 分类列表
     */
    @GetMapping("/feign/goods/category/first")
    List<Category> firstCategory();

    /**
     * 获取一级分类列表 用于商家入驻选择
     *
     * @return 分类列表
     */
    @GetMapping("/feign/goods/category/query")
    Category getById(@RequestParam String id);

    @PostMapping("/feign/goods/category/listByIdsOrderByLevel")
    List<Category> listByIdsOrderByLevel(@RequestBody List<String> asList);
}
