package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dos.Commodity;
import cn.lili.modules.goods.fallback.CommodityFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author paulG
 * @since 2022/1/14
 **/
@FeignClient(
        name = ServiceConstant.BROADCAST_SERVICE,
        contextId = "commodity",
        fallback = CommodityFallback.class)
public interface CommodityClient {

    /**
     * 添加直播商品
     *
     * @param commodity 直播商品列表
     * @return 添加结果
     */
    @PostMapping("/feign/goods/commodity/add")
    boolean addCommodity(@RequestBody List<Commodity> commodity);

    /**
     * 查询微信小程序直播商品审核状态
     */
    @GetMapping("/feign/goods/commodity/ware-house")
    void getGoodsWareHouse();

    @GetMapping("/feign/goods/commodity/deleteCommodity/{goodsId}")
    boolean deleteCommodity(@PathVariable String goodsId);
}
