package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.fallback.DraftGoodsFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * @author ftyy
 * @description: 优惠券Client
 * @date 2023/4/24
 */
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "draft-goods", fallback = DraftGoodsFallback.class)
public interface DraftGoodsClient {
    /**
     * 修改草稿商品店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/draft-goods/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
