package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dto.GoodsSkuDTO;
import cn.lili.modules.goods.fallback.GoodsIndexFallback;
import cn.lili.modules.search.entity.dos.EsGoodsIndex;
import cn.lili.modules.search.entity.dto.EsGoodsIndexDTO;
import cn.lili.modules.search.entity.dto.EsGoodsIndexUpdateDTO;
import cn.lili.modules.search.entity.dto.EsGoodsIndexUpdatePromotionsDTO;
import cn.lili.modules.search.entity.dto.EsGoodsSkuIdsSearchDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author paulG
 * @since 2022/6/20
 **/
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "goods-index", fallback = GoodsIndexFallback.class)
public interface GoodsIndexClient {

    /**
     * es 商品获取列表
     *
     * @param skuIds skuId集合
     * @return es商品模型集合
     */
    @PostMapping("/feign/goods/es")
    List<EsGoodsIndex> getEsGoodsBySkuIds(@RequestBody EsGoodsSkuIdsSearchDTO searchDTO);


    /**
     * es 商品获取
     *
     * @param id skuId
     * @return es 商品信息
     */
    @GetMapping("/feign/goods/es/{id}")
    EsGoodsIndex getEsGoodsIndex(@PathVariable String id);

    /**
     * 清除商品索引中无效促销活动
     */
    @GetMapping("/feign/goods/es/promotions/clean")
    void cleanEsGoodsIndexInvalidPromotions();

    /**
     * 获取重置的商品索引
     *
     * @param goodsSkuDTO 商品sku信息
     * @return 商品索引
     */
    @PostMapping("/feign/goods/es/reset")
    EsGoodsIndex getResetEsGoodsIndex(@RequestBody GoodsSkuDTO goodsSkuDTO);

    @PutMapping("/feign/goods/index/field")
    void updateIndexField(@RequestBody EsGoodsIndexUpdateDTO esGoodsIndexUpdateDTO);

    @PutMapping("/feign/goods/index/promotions/list")
    void updateEsGoodsIndexByList(@RequestBody EsGoodsIndexUpdatePromotionsDTO esGoodsIndexUpdatePromotionsDTO);

    @PutMapping("/feign/goods/index/promotions")
    void updateEsGoodsIndexPromotions(@RequestBody EsGoodsIndexUpdatePromotionsDTO esGoodsIndexUpdatePromotionsDTO);

    @PostMapping("/feign/goods/index/promotions/list/all")
    void updateEsGoodsIndexAllByList(@RequestBody EsGoodsIndexUpdatePromotionsDTO esGoodsIndexUpdatePromotionsDTO);

    @PostMapping("/feign/goods/index")
    void addIndex(@RequestBody EsGoodsIndexDTO goodsIndex);

    @PostMapping("/feign/goods/index/batch")
    void addIndex(@RequestBody List<EsGoodsIndexDTO> goodsIndexDTOList);

    @DeleteMapping("/feign/goods/index")
    void deleteIndex(@RequestBody Map<String, Object> queryFields);

    @PutMapping("/feign/goods/index")
    void updateIndex(@RequestBody EsGoodsIndexDTO goodsIndex);


    @PutMapping("/feign/goods/updateBulkIndex")
    void updateBulkIndex(@RequestBody List<EsGoodsIndex> goodsIndices);

    @GetMapping("/feign/goods/{id}/deleteIndexById")
    void deleteIndexById(@PathVariable String id);

    @GetMapping("/feign/goods/{id}/findById")
    EsGoodsIndex findById(@PathVariable String id);

    @DeleteMapping("/feign/goods/esGoods/deleteIndexByIds")
    void deleteIndexByIds(@RequestBody List<String> skuIdsByGoodsId);


    /**
     * 删除索引中指定的促销活动id的促销活动
     *
     * @param skuIds      商品skuId
     * @param promotionsKey 促销活动Key
     */
    @DeleteMapping("/feign/goods/esGoods/deleteEsGoodsPromotionByPromotion/{promotionsKey}")
    void deleteEsGoodsPromotionByPromotionKey(@RequestBody List<String> skuIds, @PathVariable String promotionsKey);


    /**
     * 删除索引中指定的促销活动id的促销活动
     *
     * @param promotionsKey 促销活动Key
     */
    @DeleteMapping("/feign/goods/esGoods/deleteEsGoodsPromotionByPromotionKey/{promotionsKey}")
    void deleteEsGoodsPromotionByPromotionKey(@PathVariable String promotionsKey);
}
