package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dos.StoreGoodsLabel;
import cn.lili.modules.goods.entity.vos.StoreGoodsLabelVO;
import cn.lili.modules.goods.fallback.StoreGoodsLabelFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-11 15:14
 * @description: 店铺商品分类Client
 */
@FeignClient(
        name = ServiceConstant.GOODS_SERVICE,
        contextId = "goods-label",
        fallback = StoreGoodsLabelFallback.class)
public interface StoreGoodsLabelClient {

    /**
     * 根据商家ID获取店铺分类列表
     *
     * @param storeId 商家ID
     * @return 店铺分类列表
     */
    @GetMapping("/feign/goods/listByStoreId")
    List<StoreGoodsLabelVO> listByStoreId(@RequestParam String storeId);

    /**
     * 根据分类id集合获取所有店铺分类根据层级排序
     *
     * @param ids 商家ID
     * @return 店铺分类列表
     */
    @PostMapping("/feign/goods/listByStoreIds")
    List<StoreGoodsLabel> listByStoreIds(@RequestBody List<String> ids);

    /**
     * 添加商品分类
     *
     * @param storeGoodsLabel 店铺商品分类
     * @return 店铺商品分类
     */
    @PostMapping("/feign/goods/addStoreGoodsLabel")
    StoreGoodsLabel addStoreGoodsLabel(@RequestBody StoreGoodsLabel storeGoodsLabel);

    /**
     * 修改商品分类
     *
     * @param storeGoodsLabel 店铺商品分类
     * @return 店铺商品分类
     */
    @PutMapping("/feign/goods/editStoreGoodsLabel")
    StoreGoodsLabel editStoreGoodsLabel(@RequestBody StoreGoodsLabel storeGoodsLabel);

    /**
     * 删除商品分类
     *
     * @param storeLabelId 店铺 分类 ID
     */
    @DeleteMapping("/feign/goods/removeStoreGoodsLabel")
    void removeStoreGoodsLabel(@RequestParam String storeLabelId);
}
