package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.fallback.StudioFallback;
import cn.lili.trigger.message.BroadcastMessage;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author paulG
 * @since 2022/1/17
 **/
@FeignClient(
        name = ServiceConstant.BROADCAST_SERVICE,
        contextId = "studio",
        fallback = StudioFallback.class)
public interface StudioClient {

    /**
     * 修改直播间状态
     *
     * @param broadcastMessage 直播间消息
     */
    @PutMapping("/feign/goods/studio/status")
    void updateStudioStatus(@RequestBody BroadcastMessage broadcastMessage);
}
