package cn.lili.modules.goods.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.fallback.WeChatAccessTokenFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author yuquanfeng
 * @Date 2023/8/8
 * @Description
 **/
@FeignClient(name = ServiceConstant.GOODS_SERVICE, contextId = "weichat", fallback = WeChatAccessTokenFallback.class)
public interface WeChatAccessTokenClient {
    @GetMapping("/feign/wechat/accessToken")
    String getAccessToken(@RequestParam String appId);
}
