package cn.lili.modules.goods.entity;

import cn.lili.common.utils.DateUtil;
import lombok.Getter;

import java.util.Date;

/**
 * @Author yuquanfeng
 * @Date 2023/7/10
 * @Description
 **/
@Getter
public enum ReturnStrategyRedisKeyEnum {

    ADVERT_LINK_CUMULATIVE_INCOME("推广链接累计消耗"),

    ADVERT_LINK_CUMULATIVE_INCOME_SNAPSHOT("当天切换策略时累计消耗"),

    ADVERT_LINK_INCOME_REPORT_REVENUE("当天累计上报收益"),

    ADVERT_LINK_REPORT_COUNT("上报次数"),
    ;
    private String desc;

    ReturnStrategyRedisKeyEnum(String desc){
        this.desc = desc;
    }

    public String getKey(String suffix){
        return name() + "_" + DateUtil.toString(new Date(), DateUtil.STANDARD_DATE_FORMAT) + "_" + suffix;
    }
}
