package cn.lili.modules.goods.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.goods.client.GoodsClient;
import cn.lili.modules.goods.entity.dos.Goods;
import cn.lili.modules.goods.entity.dos.GoodsSku;
import cn.lili.modules.goods.entity.dos.ReturnAddressDTO;
import cn.lili.modules.goods.entity.dos.Wholesale;
import cn.lili.modules.goods.entity.dto.GoodsSearchParams;
import cn.lili.modules.goods.entity.vos.GoodsVO;
import cn.lili.modules.store.entity.dos.Store;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 15:29
 * @description: 商品服务Fallback
 */
@Component
public class GoodsFallback implements GoodsClient {

    @Override
    public GoodsVO getGoodsVO(String goodsId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public GoodsSku getGoodsSkuByIdFromCache(String skuId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<GoodsSku> getGoodsSkuByIdFromCache(List<String> ids) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public GoodsSku getCanPromotionGoodsSkuByIdFromCache(String skuId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateStoreDetail(Store store) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void underStoreGoods(String id) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void delStoreGoods(String id) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Long count(String storeId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Integer getStock(String skuId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 添加商品评价数量
     *
     * @param commentNum 评价数量
     * @param goodsId    商品ID
     */
    @Override
    public void addGoodsCommentNum(Integer commentNum, String goodsId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Goods getById(String goodsId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<Goods> queryListByParams(GoodsSearchParams searchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<String> getSkuIdsByGoodsId(String goodsId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<GoodsSku> getGoodsSkuByList(GoodsSearchParams searchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }


    @Override
    public void updateGoodsBuyCount(String goodsId, int buyCount) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public GoodsSku getGoodsSkuById(String goodsId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateGoodsSku(GoodsSku goodsSku) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Goods getGoodsByParams(GoodsSearchParams searchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Wholesale getMatchWholesale(String goodsId, Integer num) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Long countSkuNum(String storeId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Page<GoodsSku> getGoodsSkuByPage(GoodsSearchParams searchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateGoodsMarketEnable(String categoryId, String marketEnable, String underMessage) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void categoryGoodsName(String categoryId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public ReturnAddressDTO getReturnAddress(Long goodsId) {
        throw new ServiceException(ResultCode.ERROR);
    }

}
