package cn.lili.modules.goods.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.goods.client.GoodsSkuClient;
import cn.lili.modules.goods.entity.dos.GoodsSku;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 15:32
 * @description: goodsSku Fallback
 */
@Component
public class GoodsSkuFallback implements GoodsSkuClient {

    @Override
    public GoodsSku getGoodsSkuByIdFromCache(String id) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 批量从redis中获取商品SKU信息
     *
     * @param ids SkuId集合
     * @return 商品SKU信息集合
     */
    @Override
    public List<GoodsSku> getGoodsSkuByIdFromCache(List<String> ids) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Integer getStock(String skuId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateGoodsStuck(List<GoodsSku> goodsSkus) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateGoodsSkuCommentNum(String skuId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateBatchById(List<GoodsSku> goodsSkus) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<GoodsSku> getStockWarningGoods(Integer stockWarning, String storeId) {
        throw new ServiceException(ResultCode.ERROR);
    }


}
