package cn.lili.modules.im.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.im.entity.dos.ImTalk;
import cn.lili.modules.im.entity.dto.IMTalkQueryParams;
import cn.lili.modules.im.fallback.IMFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author paulG
 * @since 2023/2/6
 **/
@FeignClient(name = ServiceConstant.IM_SERVICE, contextId = "im", fallback = IMFallback.class)
public interface IMClient {


    @PostMapping("/feign/im/talk/getImTalkList")
    List<ImTalk> getImTalkList(@RequestBody IMTalkQueryParams imTalkQueryParams);


    @PostMapping("/feign/im/talk/batch/updateImTalk")
    void updateImTalkBatch(@RequestBody List<ImTalk> imTalks);

}
