package cn.lili.modules.member.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.entity.dos.MemberAddress;
import cn.lili.modules.member.fallback.MemberAddressFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 会员收货地址client
 *
 * @author liushuai(liushuai711 @ gmail.com)
 * @since 2021/12/7 08:23
 */
@FeignClient(
        name = ServiceConstant.MEMBER_SERVICE,
        contextId = "member-address",
        fallback = MemberAddressFallback.class)
public interface MemberAddressClient {


    @PostMapping("/feign/member/address/add")
    Boolean addDefaultAddress(@RequestBody MemberAddress memberAddress);

    /**
     * 获取默认的收货地址
     */
    @GetMapping("/feign/member/address/{memberId}/default")
    MemberAddress getDefaultMemberAddress(@PathVariable String memberId);

    /**
     * 获取制定会员收货地址
     */
    @GetMapping("/feign/member/address/{shippingAddressId}}")
    MemberAddress getById(@PathVariable String shippingAddressId);
}
