package cn.lili.modules.member.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.entity.dto.MemberStatisticsSearchParams;
import cn.lili.modules.member.entity.vo.MemberDistributionVO;
import cn.lili.modules.member.fallback.MemberStatisticsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Date;
import java.util.List;

/**
 * @author paulG
 * @since 2022/6/28
 **/

@FeignClient(
        name = ServiceConstant.MEMBER_SERVICE,
        contextId = "member-statistics",
        fallback = MemberStatisticsFallback.class)
public interface MemberStatisticsClient {


    /**
     * 获取会员数量
     *
     * @return 会员统计
     */
    @GetMapping("/feign/member/statistics/getMemberCount")
    long getMemberCount();

    /**
     * 获取今日新增会员数量
     *
     * @return 今日新增会员数量
     */
    @GetMapping("/feign/member/statistics/todayMemberNum")
    long todayMemberNum();

    /**
     * 获取指定结束时间前的会员数量
     *
     * @param endTime
     * @return
     */
    @PostMapping("/feign/member/statistics/memberCount")
    long memberCount(@RequestBody Date endTime);

    /**
     * 当天活跃会员数量
     *
     * @param startTime
     * @return
     */
    @PostMapping("/feign/member/statistics/activeQuantity")
    long activeQuantity(@RequestBody Date startTime);

    /**
     * 时间段内新增会员数量
     *
     * @param searchParams
     * @return
     */
    @PostMapping("/feign/member/statistics/newlyAdded")
    long newlyAdded(@RequestBody MemberStatisticsSearchParams searchParams);


    /**
     * 查看会员数据分布
     *
     * @return 会员数据分布
     */
    @GetMapping("/feign/member/statistics/distribution")
    List<MemberDistributionVO> distribution();
}
