package cn.lili.modules.member.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.member.fallback.RechargeFallback;
import cn.lili.modules.order.trade.entity.dto.RechargeQueryParams;
import cn.lili.modules.wallet.entity.dos.Recharge;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 充值client
 *
 * @author liushuai(liushuai711 @ gmail.com)
 * @since 2021/12/7 08:22
 */
@FeignClient(name = ServiceConstant.MEMBER_SERVICE, contextId = "recharge", fallback = RechargeFallback.class)
public interface RechargeClient {

    /**
     * 根据充值订单号查询详情
     *
     * @param sn 编号
     * @return 充值订单
     */
    @GetMapping("/feign/member/recharge/query")
    Recharge getRecharge(@RequestParam String sn);

    /**
     * 支付订单
     *
     * @param sn            订单sn
     * @param receivableNo  第三方流水
     * @param paymentMethod 支付方式
     */
    @GetMapping("/feign/member/recharge/pay")
    void paySuccess(@RequestParam String sn, @RequestParam String receivableNo, @RequestParam String paymentMethod);

    /**
     * 充值订单取消
     *
     * @param sn 充值订单sn
     */
    @GetMapping("/feign/member/recharge/cancel")
    void rechargeOrderCancel(@RequestParam String sn);

    /**
     * 查询充值订单列表
     *
     * @param queryParams 查询条件
     * @return 充值订单列表
     */
    @PostMapping("/feign/member/recharge/list")
    List<Recharge> list(@RequestBody RechargeQueryParams queryParams);
}
