package cn.lili.modules.member.entity.dto;

import cn.hutool.core.text.CharSequenceUtil;
import cn.lili.common.enums.SwitchEnum;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会员搜索VO
 *
 * @author Bulbasaur
 * @since 2020/12/15 10:48
 */
@Data
public class MemberSearchParams {

    @ApiModelProperty(value = "用户名")
    private String username;

    @ApiModelProperty(value = "昵称")
    private String nickName;

    @ApiModelProperty(value = "用户手机号码")
    private String mobile;

    /**
     * @see SwitchEnum
     */
    @ApiModelProperty(value = "会员状态")
    private String disabled;

    public <T> QueryWrapper<T> queryWrapper() {
        QueryWrapper<T> queryWrapper = new QueryWrapper<>();
        if (CharSequenceUtil.isNotEmpty(username)) {
            queryWrapper.eq("username", username);
        }
        if (CharSequenceUtil.isNotEmpty(nickName)) {
            queryWrapper.eq("nick_name", nickName);
        }
        if (CharSequenceUtil.isNotEmpty(mobile)) {
            queryWrapper.eq("mobile", mobile);
        }
        if (CharSequenceUtil.isNotEmpty(disabled)) {
            queryWrapper.eq("disabled", disabled);
        }
        return queryWrapper;
    }
}
