package cn.lili.modules.message.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.message.entity.dos.Message;
import cn.lili.modules.message.fallback.MessageFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 通知类消息Client
 *
 * @author paulG
 * @since 2022/1/12
 **/
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "message", fallback = MessageFallback.class)
public interface MessageClient {

    /**
     * 添加通知消息
     * @param message
     * @return 是否成功
     */
    @PostMapping("/feign/message/save")
    Boolean save(@RequestBody Message message);

}
