package cn.lili.modules.order.order.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.aftersale.entity.dos.AfterSale;
import cn.lili.modules.order.fallback.AfterSaleStatisticsFallback;
import cn.lili.modules.statistics.entity.dto.StatisticsQueryParam;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author paulG
 * @since 2022/6/23
 **/

@FeignClient(
        name = ServiceConstant.ORDER_SERVICE,
        contextId = "after-sale-statistics",
        fallback = AfterSaleStatisticsFallback.class)
public interface AfterSaleStatisticsClient {


    /**
     * 获取待处理售后数量
     *
     * @param serviceType 售后类型
     * @return 待处理售后数量
     */
    @PostMapping("/feign/order/after-sale/statistics/applyNum")
    Long applyNum(@RequestParam String serviceType, @RequestParam String storeId);

    /**
     * 获取统计的售后
     *
     * @param statisticsQueryParam 统计搜索参数
     * @param pageVO               分页
     * @return 售后分页列表
     */
    @PostMapping("/feign/order/after-sale/statistics/getStatistics")
    Page<AfterSale> getStatistics(@RequestBody StatisticsQueryParam statisticsQueryParam);

}
