package cn.lili.modules.order.order.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.payment.entity.dos.RefundLog;
import cn.lili.modules.payment.entity.params.RefundLogParams;
import cn.lili.modules.payment.fallback.RefundLogFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author: ftyy
 * @date: 2022-01-12 9:45
 * @description: 退款日志Client
 */
@FeignClient(name = ServiceConstant.PAYMENT_SERVICE, contextId = "refundLog", fallback = RefundLogFallback.class)
public interface RefundLogClient {

    /**
     * 查询售后记录日志
     *
     * @param sn
     * @return
     */
    @GetMapping("/feign/payment/refundlog/query")
    RefundLog queryByAfterSaleSn(@RequestParam String sn);

    /**
     * 根据id获取售后日志
     *
     * @param id
     * @return
     */
    @GetMapping("/feign/payment/refundlog/getById")
    RefundLog getById(@PathVariable String id);

    @PostMapping("/feign/payment/refundlog/saveOrUpdate")
    void saveOrUpdate(@RequestBody RefundLog refundLog);

    @PostMapping("/feign/payment/refundlog/save")
    void save(@RequestBody RefundLog refundLog);

    @PostMapping("/feign/payment/refundlog/getOne")
    RefundLog getOne(@RequestBody RefundLogParams refundLogParams);
}
