package cn.lili.modules.order.order.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.RefundOrderStatisticsFallback;
import cn.lili.modules.statistics.entity.dto.StatisticsQueryParam;
import cn.lili.modules.statistics.entity.vo.RefundOrderStatisticsDataVO;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author paulG
 * @since 2022/6/28
 **/
@FeignClient(name = ServiceConstant.ORDER_SERVICE, contextId = "refund-order-statistics", fallback = RefundOrderStatisticsFallback.class)
public interface RefundOrderStatisticsClient {


    /**
     * 查询订单统计分页
     *
     * @param statisticsQueryParam 查询参数
     * @param pageVO               分页
     * @return 退款统计
     */
    @PostMapping("/feign/order/refund/statistics/getRefundOrderStatisticsData")
    Page<RefundOrderStatisticsDataVO> getRefundOrderStatisticsData(@RequestBody StatisticsQueryParam statisticsQueryParam);

    /**
     * 查询退款订单统计金额
     *
     * @param statisticsQueryParam 查询参数
     * @return 退款统计金额
     */
    @PostMapping("/feign/order/refund/statistics/getRefundOrderStatisticsPrice")
    Double getRefundOrderStatisticsPrice(@RequestBody StatisticsQueryParam statisticsQueryParam);

}
