package cn.lili.modules.order.order.entity.dto;

import cn.lili.common.utils.StringUtils;
import cn.lili.common.vo.PageVO;
import cn.lili.modules.order.order.entity.dos.Order;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;


/**
 * @author paulG
 * @since 2022/6/28
 **/

@EqualsAndHashCode(callSuper = true)
@Data
public class OrderStatisticsSearchParams extends PageVO {

    private static final long serialVersionUID = -2949514366318095263L;

    private Date[] dates;

    @ApiModelProperty(value = "店铺ID")
    private String storeId;

    public QueryWrapper<Order> getQueryWrapper() {
        QueryWrapper<Order> queryWrapper = Wrappers.query();
        //时间区间
        queryWrapper.between("create_time", dates[0], dates[1]);
        //如果有店铺id传入，则查询店铺
        if (StringUtils.isNotEmpty(this.storeId)) {
            queryWrapper.eq("store_id", this.storeId);
        }
        //查询流水金额和订单数量
        queryWrapper.select("SUM(flow_price) AS price , COUNT(0) AS num");
        return queryWrapper;
    }
}
