package cn.lili.modules.order.trade.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.TradeFallback;
import cn.lili.modules.order.order.entity.dos.Trade;
import cn.lili.modules.payment.dto.PaymentSuccessParams;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 交易 client
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.ORDER_SERVICE, contextId = "trade", fallback = TradeFallback.class)
public interface TradeClient {

    /**
     * 获取交易
     *
     * @param sn 订单编号
     * @return 交易详情
     */
    @GetMapping("/feign/trade/{sn}")
    Trade getBySn(@PathVariable String sn);

    /**
     * 交易支付
     *
     * @param sn 订单编号
     */
    @PostMapping("/feign/trade/pay")
    void payTrade(@RequestBody PaymentSuccessParams paymentSuccessParams);
}
