package cn.lili.modules.page.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.page.entity.dos.PageData;
import cn.lili.modules.page.entity.dto.PageDataDTO;
import cn.lili.modules.page.entity.vos.PageDataVO;
import cn.lili.modules.page.fallback.PageDataFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author: ftyy
 * @date: 2022-01-17 15:12
 * @description: 页面数据Client
 */
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "page-Data",fallback = PageDataFallback.class)
public interface PageDataClient {

    /**
     * 添加店铺页面
     * 用于初次开店，生成店铺首页
     *
     * @param storeId 店铺ID
     * @return 页面
     */
    @GetMapping("/feign/system/page-Data/addStorePageData")
    void addStorePageData(@RequestParam String storeId);

    /**
     * 添加页面
     *
     * @param pageData 页面
     * @return 页面
     */
    @PostMapping("/feign/system/page-Data/addPageData")
    PageData addPageData(@RequestBody PageData pageData);

    /**
     * 修改页面
     *
     * @param pageData 页面
     * @return 页面
     */
    @PutMapping("/feign/system/page-Data/updatePageData")
    PageData updatePageData(@RequestBody PageData pageData);

    /**
     * 发布页面
     *
     * @param id 页面ID
     * @return 页面
     */
    @PutMapping("/feign/system/page-Data/releasePageData/{id}")
    PageData releasePageData(@PathVariable String id);

    /**
     * 删除页面
     *
     * @param id 页面ID
     * @return 操作状态
     */
    @DeleteMapping("/feign/system/page-Data/removePageData/{id}")
    boolean removePageData(@PathVariable String id);

    /**
     * 获取页面
     * 用户前台页面展示
     *
     * @param pageDataDTO 页面数据DTO
     * @return
     */
    @PostMapping("/feign/system/page-Data/getPageData")
    PageDataVO getPageData(@RequestBody PageDataDTO pageDataDTO);

    @PostMapping("/feign/system/page-Data/save")
    void save(@RequestBody PageData pageData);

    @DeleteMapping("/feign/system/page-Data/removeById/{pageDataId}")
    void removeById(@PathVariable String pageDataId);
}
