package cn.lili.modules.payment.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.aftersale.entity.dos.AfterSale;
import cn.lili.modules.order.order.entity.dos.Order;
import cn.lili.modules.payment.fallback.PaymentFallback;
import cn.lili.modules.wallet.entity.dos.MemberWithdrawApply;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 物流配置客户端
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.PAYMENT_SERVICE, contextId = "payment", fallback = PaymentFallback.class)
public interface PaymentClient {


    @PostMapping("/feign/payment/refund/order")
    void refundOrder(@RequestBody Order order);

    /**
     * 根据id获取物流配置
     */
    @PostMapping("/feign/payment/refund")
    void refund(@RequestBody AfterSale afterSale);

    /**
     * 线下收款
     */
    @PostMapping("/feign/payment/offline/callback")
    void callBack(@RequestBody Order order);

    @PostMapping("/feign/payment/transfer/{paymentMethodEnum}")
    boolean transfer(@PathVariable String paymentMethodEnum, @RequestBody MemberWithdrawApply memberWithdrawApply);


    /**
     * 支付回查
     */
    @PostMapping("/feign/payment/back/check")
    void backCheck();

}
