package cn.lili.modules.payment.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.aftersale.entity.dos.AfterSale;
import cn.lili.modules.order.fallback.StoreFlowFallback;
import cn.lili.modules.order.order.entity.dos.Order;
import cn.lili.modules.payment.entity.dos.StoreFlow;
import cn.lili.modules.order.order.entity.dto.StoreFlowQueryDTO;
import cn.lili.modules.store.entity.dos.Bill;
import cn.lili.modules.store.entity.dos.Store;
import cn.lili.modules.store.entity.dto.BillSearchParams;
import cn.lili.modules.store.entity.vos.StoreFlowPayDownloadVO;
import cn.lili.modules.store.entity.vos.StoreFlowRefundDownloadVO;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Date;
import java.util.List;

/**
 * 店铺流水 client
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.PAYMENT_SERVICE, contextId = "store-flow", fallback = StoreFlowFallback.class)
public interface StoreFlowClient {

    /**
     * 获取结算单的入账流水
     *
     * @param storeFlowQueryDTO 查询条件
     * @return 入账流水
     */
    @PostMapping("/feign/store-flow/query/pay")
    List<StoreFlowPayDownloadVO> getStoreFlowPayDownloadVO(@RequestBody StoreFlowQueryDTO storeFlowQueryDTO);

    /**
     * 获取结算单的退款流水
     *
     * @param storeFlowQueryDTO 查询条件
     * @return 退款流水
     */
    @GetMapping("/feign/store-flow/query/refund")
    List<StoreFlowRefundDownloadVO> getStoreFlowRefundDownloadVO(StoreFlowQueryDTO storeFlowQueryDTO);


    /**
     * 支付订单
     *
     * @param orderSn 订单编号
     */
    @PostMapping("/feign/store-flow/pay")
    void payOrder(@RequestBody String orderSn);

    /**
     * 流水退款
     *
     * @param afterSale 流水退款
     */
    @PostMapping("/feign/store-flow/refund-order")
    void refundOrder(@RequestBody AfterSale afterSale);

    /**
     * 取消订单
     *
     * @param orderSn 订单
     */
    @PostMapping("/feign/store-flow/cancel")
    void orderCancel(@RequestBody String orderSn);

    /**
     * 获取一条流水
     *
     * @param storeFlowQueryDTO 查询条件
     * @return 流水信息
     */
    @PostMapping("/feign/store-flow/query")
    StoreFlow queryOne(@RequestBody StoreFlowQueryDTO storeFlowQueryDTO);

    /**
     * 查询店铺流水集合
     *
     * @param storeFlowQueryDTO 查询店铺流水
     * @return 流水集合
     */
    @PostMapping("/feign/store-flow/query/list")
    List<StoreFlow> listStoreFlow(@RequestBody StoreFlowQueryDTO storeFlowQueryDTO);

    /**
     * 获取商家流水
     *
     * @param storeFlowQueryDTO 查询参数
     * @return 返回分页
     */
    @PostMapping("/feign/store-flow/query/getStoreFlow")
    Page<StoreFlow> getStoreFlow(@RequestBody StoreFlowQueryDTO storeFlowQueryDTO);


    @PostMapping("/feign/store-flow/bill/order")
    Bill getOrderBill(@RequestBody BillSearchParams searchParams);

    @PostMapping("/feign/store-flow/bill/refund")
    Bill getRefundBill(@RequestBody BillSearchParams searchParams);

    @PutMapping("/feign/store-flow/bill/editBillTime")
    void editBillTime(@RequestBody String orderSn);

    /**
     * 修改店铺流水中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/store-flow/bill/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
