package cn.lili.modules.payment.dto;

import cn.lili.modules.payment.entity.dos.PaymentWakeup;
import cn.lili.modules.payment.entity.enums.PaymentMethodEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * PaymentSuccessParams
 *
 * @author Chopper
 * @version v1.0
 * 2021-04-27 16:24
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PaymentSuccessParams {

    /**
     * 支付方式
     */
    private String paymentMethod;
    /**
     * 第三方流水
     */
    private String receivableNo;

    /**
     * 支付金额
     */
    private Double price;

    /**
     * 支付参数
     */
    private PayParam payParam;

    /** 子单信息 */
    private List<OrderPaySuccessDTO> subOrders;

    /** 支付订单号 */
    private String outTradeNo;

    public PaymentSuccessParams(PaymentWakeup paymentWakeup) {
        PayParam payParam = new PayParam();
        payParam.setOrderType(paymentWakeup.getOrderType());
        payParam.setClientType(paymentWakeup.getClientType());
        payParam.setSn(paymentWakeup.getOrderSn());
        this.payParam = payParam;

        this.paymentMethod = PaymentMethodEnum.paymentPluginOf(paymentWakeup.getPaymentMethod()).name();

        this.receivableNo = paymentWakeup.getPaymentReceivableNo();
        this.price = paymentWakeup.getPrice();
    }

}
