package cn.lili.modules.payment.dto;

import cn.lili.modules.payment.entity.dos.PaymentWakeup;
import lombok.Data;
import lombok.ToString;

import java.util.Calendar;
import java.util.Date;

/**
 * 支付参数
 *
 * @author Chopper
 * @since 2020/12/19 11:46
 */
@Data
@ToString
public class PaymentWakeupParam {


    //支付唤起流水号
    private String outTradeNo;

    //支付唤起模型
    private PaymentWakeup paymentWakeup;

    // 支付参数
    private PayParam payParam;


    /**
     * 支付超时时间 3分钟
     */
    protected Long paymentTimeout = 3L;


    public Long getPaymentTimeout() {
        if (paymentTimeout == null) {
            paymentTimeout = 3L;
        }
        return paymentTimeout;
    }

    public Long getPaymentTimeoutMillisecond() {
        return System.currentTimeMillis() + 1000 * 60 * getPaymentTimeout();
    }

    public Date getTimeoutExpress() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MINUTE, calendar.get(Calendar.MINUTE) + getPaymentTimeout().intValue());
        return calendar.getTime();
    }

    public String getMinute() {
        return getPaymentTimeout() + "m";
    }


}
