package cn.lili.modules.payment.entity.params;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

/**
 * @author: ftyy
 * @date: 2022-01-20 10:23
 * @description: 退款日志
 */
@Data
@Builder
public class RefundLogParams {

    @ApiModelProperty(value = "支付第三方付款流水")
    private String paymentReceivableNo;


    public <T> QueryWrapper<T> queryWrapper(){
        QueryWrapper<T> wrapper = new QueryWrapper<>();

        wrapper.eq(CharSequenceUtil.isNotEmpty(paymentReceivableNo),"payment_receivable_no", paymentReceivableNo);

        return wrapper;
    }
}
